
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

/***************************************************************************/
/* PROGRAM: paload
/*
/* DESCRIPTION:
/*    Loads a color pallette into the hardware color look up table.
/*
/* USAGE:
/* Usage   : paload [-options] <pallette file>
/*            -a (ascii file)
/*            -b (binary file (default))
/*            -h (hdf file)
/*
/* OPTIONS:
/*    -a : do i/o with ascii format file
/*    -b : do i/o with binary format file
/*    -h : do i/o with hdf format file
/*
/* COMMENTS:
/*    Default file format is 'paload' binary pallette format.
/*    This particular implementation is for the SGI/4D series.
/*    The ascii format consists of 256 lines, 3 integers per
/*    line.  The integers are clear text encoded and correspond
/*    to the R G B intensity for a given lut entry.  Each intensity
/*    is specified as an integer in the range [0..255].  There
/*    are 256 color map entries which are loaded into the hardware
/*    lut positions 512-767 respectively.
/*
/* EXAMPLE:
/*    The first three lines of an ascii color pallette file for a
/*    gray ramp would look like:
/*
/*        0 0 0
/*        1 1 1
/*        2 2 2
/*        ...etc
/*
/* SEE ALSO:
/*    palshow
/*
/***************************************************************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>

#define NOPTS 4
#define MINARGS 2

#define WINDOW_STR "cpaload"

void exit();

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *palfile;
	unsigned char palette[256][3];
	int ir,ig,ib;
	register int i,i1;

	pname = "paload";
	pver = 1.2;
	dev_month = 5;
	dev_year = 1990;
	pstat = 'P';
	pstr = "public domain software";

	opt_desc[0] = "paload [-options] <pallette file>";
	opt_array[0] = opt_desc[0];
	opt_array[1] = "-a"; opt_desc[1] = "(ascii file)";
	opt_array[2] = "-b"; opt_desc[2] = "(binary file (default))";
	opt_array[3] = "-h"; opt_desc[3] = "(hdf file)";
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > (MINARGS))
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	palfile  = argv[argc-1];

	if (opt_loc[1]){
		err_ret = seqpal_io(palfile,"r",palette);
		if (err_ret){
			printf("%s: Error with i/o\n",palfile);
			exit(1);
		}
	}
	else if (opt_loc[2]){
		err_ret = seqpal_io(palfile,"rb",palette);
		if (err_ret){
			printf("%s: Error with i/o\n",palfile);
			exit(1);
		}
	}
	else if (opt_loc[3]){
		err_ret = DFPgetpal(palfile,palette);
		if (err_ret){
			printf("%s: Error with i/o\n",palfile);
			exit(1);
		}
	}
	else{
		err_ret = DFPgetpal(palfile,palette);
		if (!err_ret) goto gxstart;

		err_ret = seqpal_io(palfile,"r",palette);
		if (!err_ret) goto gxstart;

		err_ret = seqpal_io(palfile,"rb",palette);
		if (!err_ret) goto gxstart;

		printf("%s: Error with i/o\n",palfile);
		exit(1);
	}

gxstart:
	noport();
	winopen(WINDOW_STR);
	onemap();
	singlebuffer();
	drawmode(NORMALDRAW);
	gconfig();

	i = 256;
	do{
		i--;
		i1=i|512; /* statement equivalent to i1=i+512 */

		ir=palette[i][0];
		ig=palette[i][1];
		ib=palette[i][2];

		mapcolor(i1, ir,ig,ib);
	}while(i);

	gexit();

	return(0);

}

