
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int seqimg_io()
/*
/* DESCRIPTION:
/*    Performs input/output on 'seq' format images (8 and 24 bits).
/*
/* USAGE:
/*    error_ret = seqimg_io(fname,xsiz,ysiz,ibits,imgio_cmd,buff);
/*
/* ARGUMENTS:
/*    char           *fname     (in) : filename of image
/*    int            xsiz       (in) : X dimension of image
/*    int            ysiz       (in) : Y dimension of image
/*    int            ibits      (in) : bits per pixel  [8 or 24]
/*    char           imgio_cmd  (in) : i/o operation (rb,wb)
/*    unsigned char  buff[]     (in/out) : image array
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : illegal value for ibits
/*    2 : i/o open error with imgio_cmd = "rb"
/*    3 : i/o read error with imgio_cmd = "rb"
/*    4 : i/o open error with imgio_cmd = "wb"
/*    5 : i/o write error with imgio_cmd = "wb"
/*    6 : invalid imgio_cmd argument
/*
/* COMMENTS:
/*    8-bit seq format consists of one 8-bit unsigned char per
/*    pixel, each with a value of [0..255] which will be used
/*    to index a color in a color look-up table.  24-bit seq
/*    format consists of three 8-bit unsigned char's per pixel,
/*    each with a value of [0..255].  Every three successive
/*    bytes beginning with the first byte in the file correspond
/*    to the red,green,blue intensity of a given pixel.  The
/*    technical term for this is "pixel interleaving."  For example,
/*    the first three bytes in a file would correspond to the
/*    RGB intensity of the first pixel, the second three bytes in
/*    the file would correspond to the second pixel,  and so forth...
/*
/* EXAMPLE:
/* SEE ALSO:
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : November 30, 1988
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

#define ONE 1

int seqimg_io(fname,xsiz,ysiz,ibits,imgio_cmd,buff)
char *fname;
int xsiz,ysiz,ibits;
char *imgio_cmd;
unsigned char buff[];
{
	register int i;
	FILE *fd1;
	int err_ret;
	int num_bytes,num_rec;

	err_ret = 0;

	if (ibits == 8)
		num_bytes = xsiz * ysiz * sizeof(char);
	else if (ibits == 24)
		num_bytes = xsiz * ysiz * sizeof(char) * 3;
	else{
		err_ret = 1;
		goto error;
	}

	if (!strcmp(imgio_cmd,"rb")){
		if ((fd1=fopen(fname,imgio_cmd))==NULL){
			err_ret = 2;
			goto error;
		}
		num_rec=fread(buff,num_bytes,ONE,fd1);
		if (num_rec<ONE){
			err_ret = 3;
			fclose(fd1);
			goto error;
		}
		fclose(fd1);
	}
	else if (!strcmp(imgio_cmd,"wb")){
		if ((fd1=fopen(fname,imgio_cmd))==NULL){
			err_ret = 4;
			goto error;
		}
		num_rec=fwrite(buff,num_bytes,ONE,fd1);
		if (num_rec<ONE){
			err_ret = 5;
			fclose(fd1);
			goto error;
		}
		fclose(fd1);
	}
	else{
		err_ret = 6;
		goto error;
	}

error:
#if RTE_PRERR
	err_msg("seqimg_io",err_ret);
#endif
	return(err_ret);
}
