/* 
 *
 * eltypes.h: Element types supported by the interface reader
 *
 * Last Update: 17-JUN-92
 *
 *
 * ABAQUS_name, Geometry_Type, Shape_Fun_Order, Stress_Recovery_Type
 *
 */
    "Unknown" , GEOM_ILLEGAL , ORDER_ILLEGAL  , STR_ILLEGAL,
    "B21"     , GEOM_LINE    , ORDER_LINEAR   , STR_BEAM,
    "B21H"    , GEOM_LINE    , ORDER_LINEAR   , STR_BEAM,
    "B31"     , GEOM_LINE    , ORDER_LINEAR   , STR_BEAM,
    "B31H"    , GEOM_LINE    , ORDER_LINEAR   , STR_BEAM,
    "B32"     , GEOM_LINE    , ORDER_PARABOLIC, STR_BEAM,
    "B32H"    , GEOM_LINE    , ORDER_PARABOLIC, STR_BEAM,

    "C1D2"    , GEOM_LINE    , ORDER_LINEAR   , STR_SOLID,
    "C1D2H"   , GEOM_LINE    , ORDER_LINEAR   , STR_SOLID,
    "C1D2T"   , GEOM_LINE    , ORDER_LINEAR   , STR_SOLID,
    "C1D3"    , GEOM_LINE    , ORDER_PARABOLIC, STR_SOLID,
    "C1D3H"   , GEOM_LINE    , ORDER_PARABOLIC, STR_SOLID,
    "C1D3T"   , GEOM_LINE    , ORDER_PARABOLIC, STR_SOLID,

    "CPS3"    , GEOM_TRIANGLE, ORDER_LINEAR   , STR_SOLID,
    "CPS4"    , GEOM_QUAD    , ORDER_LINEAR   , STR_SOLID,
    "CPS4R"   , GEOM_QUAD    , ORDER_LINEAR   , STR_SOLID,
    "CPS4T"   , GEOM_QUAD    , ORDER_LINEAR   , STR_SOLID,
    "CPS6"    , GEOM_TRIANGLE, ORDER_PARABOLIC, STR_SOLID,
    "CPS8"    , GEOM_QUAD    , ORDER_PARABOLIC, STR_SOLID,
    "CPS8R"   , GEOM_QUAD    , ORDER_PARABOLIC, STR_SOLID,
    "CPS8RT"  , GEOM_QUAD    , ORDER_PARABOLIC, STR_SOLID,
    "CPS8T"   , GEOM_QUAD    , ORDER_PARABOLIC, STR_SOLID,

    "C3D4"    , GEOM_TETRA   , ORDER_LINEAR   , STR_SOLID,
    "C3D4H"   , GEOM_TETRA   , ORDER_LINEAR   , STR_SOLID,
    "C3D10"   , GEOM_TETRA   , ORDER_PARABOLIC, STR_SOLID,
    "C3D10H"  , GEOM_TETRA   , ORDER_PARABOLIC, STR_SOLID,

    "C3D6"    , GEOM_WEDGE   , ORDER_LINEAR   , STR_SOLID,
    "C3D6H"   , GEOM_WEDGE   , ORDER_LINEAR   , STR_SOLID,
    "C3D15"   , GEOM_WEDGE   , ORDER_PARABOLIC, STR_SOLID,
    "C3D15H"  , GEOM_WEDGE   , ORDER_PARABOLIC, STR_SOLID,


    "C3D8"    , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,
    "C3D8H"   , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,
    "C3D8R"   , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,
    "C3D8RH"  , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,
    "C3D8HT"  , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,
    "C3D8T"   , GEOM_HEXA    , ORDER_LINEAR   , STR_SOLID,

    "C3D20"   , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20H"  , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20R"  , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20RH" , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20RHT", GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20HT" , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20RT" , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,
    "C3D20T"  , GEOM_HEXA    , ORDER_PARABOLIC, STR_SOLID,

    "STRI3"   , GEOM_TRIANGLE, ORDER_LINEAR   , STR_SHELL,
    "STRI35"  , GEOM_TRIANGLE, ORDER_LINEAR   , STR_SHELL,

    "S4R"     , GEOM_QUAD    , ORDER_LINEAR   , STR_SHELL,
    "S4R5"    , GEOM_QUAD    , ORDER_LINEAR   , STR_SHELL,
    "S8R"     , GEOM_QUAD    , ORDER_PARABOLIC, STR_SHELL,
    "S8RT"    , GEOM_QUAD    , ORDER_PARABOLIC, STR_SHELL,
    "S8R5"    , GEOM_QUAD    , ORDER_PARABOLIC, STR_SHELL,
    "S9R5"    , GEOM_QUAD    , ORDER_PARABOLIC, STR_SHELL,

    "DC2D3"   , GEOM_TRIANGLE, ORDER_LINEAR   , STR_ILLEGAL,
    "DC2D4"   , GEOM_QUAD    , ORDER_LINEAR   , STR_ILLEGAL,
    "DC2D6"   , GEOM_TRIANGLE, ORDER_PARABOLIC, STR_ILLEGAL,
    "DC2D8"   , GEOM_QUAD    , ORDER_PARABOLIC, STR_ILLEGAL,

    "DC3D4"   , GEOM_TETRA   , ORDER_LINEAR   , STR_ILLEGAL,
    "DC3D6"   , GEOM_WEDGE   , ORDER_LINEAR   , STR_ILLEGAL,
    "DC3D8"   , GEOM_HEXA    , ORDER_LINEAR   , STR_ILLEGAL,
    "DC3D10"  , GEOM_TETRA   , ORDER_PARABOLIC, STR_ILLEGAL,
    "DC3D15"  , GEOM_WEDGE   , ORDER_PARABOLIC, STR_ILLEGAL,
    "DC3D20"  , GEOM_HEXA    , ORDER_PARABOLIC, STR_ILLEGAL,

    NULL      , GEOM_ILLEGAL , ORDER_ILLEGAL  , STR_ILLEGAL,

