#!/bin/sh
#
# Script for automated build of Elmer
# 
# Juhani Kataja / 2014
# Peter Råback / 2020
# 
ARCBASE="D:/ElmerArchive"
BUILDBASE="D:/ElmerBuilder"

BUILD_ARCHIVE_DIR=${ARCBASE}/ElmerFEM-gui-occ-nompi-`date +%Y-%m-%d`
mkdir $BUILD_ARCHIVE_DIR

BUILD_LOG_FNAME=$BUILD_ARCHIVE_DIR/elmer-build-log.txt
BUILD_ERR_FNAME=$BUILD_ARCHIVE_DIR/elmer-build-err.txt
touch $BUILD_LOG_FNAME
touch $BUILD_ERR_FNAME
echo -- Build started `date` -------- > $BUILD_LOG_FNAME
echo -- Build started `date` -------- > $BUILD_ERR_FNAME

# copy this script for reference
cp build_gui_occ_nompi.sh $BUILD_ARCHIVE_DIR

ELMER_WIN_GIT_BRANCH="devel"

# have the builddir unique (includes day and time) so we can test many scripts at same time
ELMER_BUILD_DIR=${BUILDBASE}/build-gui-occ-nompi-`date +%Y-%m-%d-at-%H-%M`

ELMER_SOURCE_DIR="${BUILDBASE}/elmerfem"
ELMER_FEM_REVISION=Release

echo build: $ELMER_BUILD_DIR
echo src: $ELMER_SOURCE_DIR

if ! pushd $ELMER_SOURCE_DIR ; then
  exit -1
fi

git checkout $ELMER_WIN_GIT_BRANCH
git pull --rebase

mkdir $ELMER_BUILD_DIR
pushd $ELMER_BUILD_DIR

##	-DCMAKE_PREFIX_PATH:PATH="c:/ElmerBuild/src/qt-everywhere-opensource-src-4.8.6;c:/ElmerBuild/opt/lapack-3.5.0;c:/ElmerBuild/opt/vtk-6.1.0;c:/elmerbuild/opt/qwt-6.1.0;c:/ElmerBuild/opt/oce-0.15;c:/ElmerBuild/opt/msmpi;c:/ElmerBuild/opt/tcl8.5.17;c:/ElmerBuild/opt/tk8.5.17"\

echo starting cmake
cmake -G "MSYS Makefiles" \
	-DNSIS_GFORTRAN_RUNTIME_FILENAME:STRING="x86_64-w64-mingw32-gfortran.exe" \
	-DCMAKE_BUILD_TYPE:STRING=Release \
    -DCMAKE_PREFIX_PATH:PATH="d:/msys64/mingw64/bin;d:/msys64/mingw64/lib;" \
	-DQWT_INCLUDE_DIR="d:/msys64/mingw64/include/qwt" \
	-DQWT_LIBRARY="d:/msys64/mingw64/bin/qwt.dll" \
	-DWITH_MPI:BOOL=FALSE \
	-DWITH_OpenMP:BOOL=FALSE \
	-DWITH_Mumps:BOOL=FALSE \
	-DWITH_Hypre:BOOL=FALSE \
	-DWITH_LUA:BOOL=TRUE \
	-DWITH_Zoltan:BOOL=FALSE \
	-DWITH_ElmerIce:BOOL=FALSE \
	-DWITH_Trilinos:BOOL=FALSE  \
	-DWITH_QT5:BOOL=TRUE	\
	-DWITH_ELMERGUI:BOOL=TRUE \
    -DWITH_QWT:BOOL=TRUE \
    -DWITH_VTK:BOOL=TRUE \
    -DWITH_PARAVIEW:BOOL=TRUE \
    -DWITH_OCC:BOOL=TRUE \
    -DWITH_MATC:BOOL=TRUE \
    -DWITH_ELMERPOST:BOOL=FALSE \
    -DWITH_ELMERGUITESTER:BOOL=FALSE \
    -DWITH_ELMERGUILOGGER:BOOL=FALSE \
	-DBUNDLE_STRIPPED_GFORTRAN:BOOL=TRUE \
	-DBUNDLE_MSMPI_REDIST:BOOL=FALSE \
    -DCPACK_BUNDLE_EXTRA_WINDOWS_DLLS:BOOL=TRUE \
    -DCPACK_PACKAGE_BASE_FILE_NAME:STRING=elmerfem-nightly \
    -DCPACK_PACKAGE_FILE_NAME:STRING="ElmerFEM-gui-nompi-Windows-AMD64" \
    -DELMER_TESTS_PACKAGE_FILENAME:STRING="ElmerFEM-tests.tar.gz" \
    -DELMER_FEM_REVISION:STRING=$ELMER_FEM_REVISION \
	$ELMER_SOURCE_DIR > $BUILD_LOG_FNAME 2> $BUILD_ERR_FNAME

make package >> $BUILD_LOG_FNAME 2>> $BUILD_ERR_FNAME

INSTALLER_FNAME=`echo *.exe`
ZIP_FNAME=`echo *.zip`
echo Built $INSTALLER_FNAME
echo Built $ZIP_FNAME

# commented out for speed
# make ElmerTests_package >> $BUILD_LOG_FNAME 2>> $BUILD_ERR_FNAME

echo "Done building, copying " *.tar.gz *.zip *.exe to $BUILD_ARCHIVE_DIR >> $BUILD_LOG_FNAME
mv *.tar.gz *.zip *.exe $BUILD_ARCHIVE_DIR

pushd $BUILD_ARCHIVE_DIR 
shasum -b $INSTALLER_FNAME > $INSTALLER_FNAME.sha
shasum -b $ZIP_FNAME > $ZIP_FNAME.sha
cp *.zip *.exe ..

popd 
popd
rm -r $ELMER_BUILD_DIR
cd ..






	

     
