
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)kbd.c	1.10	(NCSA)	8/10/87";
#endif lint

#include <sys/types.h>
#include <sys/file.h>
#include <errno.h>
#include <signal.h>
#include <sgtty.h>
#include <suntool/sunview.h>
#include <suntool/scrollbar.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <sundev/kbd.h>
#include <sundev/kbio.h>
#include <ctype.h>
#include "../VS/vskeys.h"
#include "defs.h"
#include "session.h"
#include <stdio.h>

/*
** keyboard char handler
*/

Notify_value kbdhandler(canvas, event, arg, type)
Canvas				canvas;
Event				*event;
Notify_arg			arg;
Notify_event_type	type;
{
	char			buf[30];
	int				c;
	char			cc;
	int				z;
	int				w;
	int				n;
	extern caddr_t	(*tel_fns[])();
	extern Canvas	RGSgetcanvas();

	z = RSgetnet(Session.s_canvas);
	w = RSgetwin(Session.s_canvas);
	n = RSgetnum(Session.s_canvas);

	c = event_id(event);
	sprintf(buf, "event = %d\r\n",c);
	debug(4,buf);

	switch (c) {

		case LOC_STILL:
		case LOC_WINENTER:
		case LOC_WINEXIT:
		case LOC_RGNENTER:
			return;

		case LOC_MOVE:
		case LOC_DRAG:
		case LOC_TRAJECTORY:
		case LOC_RGNEXIT:

			/*
			** user exited, draw box
			*/

			if (canvas != Session.s_canvas)
				RGSrband(canvas, event);
			return;

		case WIN_REPAINT:
			return;
		case WIN_RESIZE:
			return;
		case MS_RIGHT:
			if (canvas == Session.s_canvas)
				RSmenu(0,event);
			else {
				int i;
				for (i = 0; i < MAXTEK; i++) {
					if (canvas == RGSgetcanvas(i)) 
						display_tek_menu(i,event);
				}
				return;
			}

		case MS_MIDDLE:
			return;
		case MS_LEFT:

			/*
			** draw a rubber band box for zoom
			*/

			if (canvas != Session.s_canvas) 
				if (Session.s_tekgin)
					RGSginoff(canvas,event_x(event), event_y(event),'\r');
				else
					RGSrband(canvas, event);

			return;
		case KBD_USE:
				return;
		case KBD_DONE:
				return;

		case KEY_TOP(1):
			VSkbsend(w,VSF1);
			break;
		case KEY_TOP(2):
			VSkbsend(w,VSF2);
			break;
		case KEY_TOP(3):
			VSkbsend(w,VSF3);
			break;
		case KEY_TOP(4):
			VSkbsend(w,VSF4);
			break;
		case KEY_TOP(5):
			VSkbsend(w,VSKM);
			break;
		case KEY_TOP(6):
			VSkbsend(w,VSKC);
			break;
		case KEY_TOP(7):
			VSkbsend(w,VSKP);
			break;
		case KEY_TOP(9):
			Session.s_lock = !Session.s_lock;
			break;

		case KEY_RIGHT(1):
			VSkbsend(w,VSK7);
			break;
		case KEY_RIGHT(2):
			VSkbsend(w,VSK8);
			break;
		case KEY_RIGHT(3):
			VSkbsend(w,VSK9);
			break;
		case KEY_RIGHT(4):
			VSkbsend(w,VSK4);
			break;
		case KEY_RIGHT(5):
			VSkbsend(w,VSK5);
			break;
		case KEY_RIGHT(6):
			VSkbsend(w,VSK6);
			break;
		case KEY_RIGHT(7):
			VSkbsend(w,VSK1);
			break;
		case KEY_RIGHT(8):
			return;
		case KEY_RIGHT(9):
			VSkbsend(w,VSK3);
			break;
		case KEY_RIGHT(10):
			return;
		case KEY_RIGHT(11):
			VSkbsend(w,VSK2);
			break;
		case KEY_RIGHT(12):
			return;
		case KEY_RIGHT(13):
			VSkbsend(w,VSK0);
			break;
		case KEY_RIGHT(14):
			return;
		case KEY_RIGHT(15):
			VSkbsend(w,VSKE);
			break;

		/*
		** scroll bars
		*/

		case SCROLL_REQUEST:
		case SCROLL_ENTER:
		case SCROLL_EXIT:
			if (canvas == Session.s_canvas)
				RSscroll(canvas, event, arg, type);
			else
				RGSscroll(canvas, event, arg, type);
			return;

		default:	
			if (canvas == Session.s_canvas)
				Session.s_termstate = VTTYPE;
			else
				if (Session.s_tekgin == TRUE) {
					RGSginoff(canvas, event_x(event), event_y(event), (char)c);
			}
			else {
				int i;
				for (i = 0; i < MAXTEK; i++)
					if (canvas ==  RGSgetcanvas(i)) {
						Session.s_termstate = TEKTYPE;
						Session.s_tekwin = i;
						VGuncover(i);
						break;
					}

				if (i == MAXTEK)
					Session.s_termstate = VTTYPE;
					
			}
			if(c > 127)
				return;
			cc = (char)c;

			if (Session.s_spcflag) {
				int i;

				for (i = 0; i < MAXDEFCHARS; i++)
					if (cc == Session.s_special[i]) {
						tel_fns[i]();
						return;
					}
			}

			if (Session.s_lock) {
				Session.s_lock = 0;
				return;
			}

			/*
			** remote echo
			*/

			if (Session.s_echo)
				switch (cc) {
					case '\r':
						write(z, "\r\n",2);
						break;
					case '\n':
						write(z, "\r\n",2);
						break;
					default:
						write(z, &cc, 1);
						break;
				}

			/*
			** local echo, line mode
			*/

			else
				newkey(c);
	}
}

/*
** newkey -- process a key for line buffered mode
*/

newkey(c)
int c;
{
	char cc;
	int i;
	int count;
	char *lmode = Session.s_linemode;
	char *cntrol();

	count = strlen(lmode);

	lmode += count;

	cc = (char)c;

	/*
	** do something with it
	*/

	if (c == '\r' || c == '\n') {
			parse(&Session,"\r\n",2);
			strcat(Session.s_linemode,"\r\n");
			lmode = Session.s_linemode;
			netwrite(Session.s_winval,lmode,strlen(lmode));
			Session.s_linemode[0] = '\0';
			return;
	}
	else

		if (c == '\b' || c == '\177' || c == Session.s_special[0]) {
			if (count == 0)
				return;

			*--lmode = '\0';
			lmode--;
			parse(&Session,"\b \b",3);
			return;
		}

	else
		if (c == '' || c == Session.s_special[1]) {
			lmode = Session.s_linemode;
			for (i = 0; i < count; i++)
				parse(&Session,"\b \b",3);
			count = 0;
			*lmode = 0;
			return;

		}

	else {
		if (count == 78) {				/* to length limit */
			*lmode = '\0';				/* terminate */
			return;
		}

		/*
		** printing chars, just append
		*/

		if (c > 31 && c < 127) {
			parse(&Session,&cc,1);
			*lmode++ = cc;			/* add to string */
			*lmode = '\0';			/* terminate the string */
			return;
		}

		/*
		** control chars that aren't special, send thru
		*/

		else {
			*lmode++ = cc;			/* add to string */
			*lmode = '\0';			/* terminate the string */

			parse(&Session,cntrol(cc),2);
			lmode = Session.s_linemode;
			netwrite(Session.s_winval,lmode,strlen(lmode));
			Session.s_linemode[0] = '\0';
				return;
		}
	}
}

/*
** if network buffer is non empty, flush it
*/

flushlbuf()
{
	if (Session.s_linemode[0] == '\0')
		return;

	else newkey('\r');
}

static char cbuf[3];

/*
 * Construct a control character sequence
 * for a special character.
 */

char *cntrol(c)
int c;
{

	if (c == 0x7f)
		return ("^?");
	if (c >= 0x20) {
		cbuf[0] = c;
		cbuf[1] = 0;
	} else {
		cbuf[0] = '^';
		cbuf[1] = '@'+c;
		cbuf[2] = 0;
	}
	return (cbuf);
}
