/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>

#include "viewer.h"
#include "view.h"
#include "net.h"
#include "mode.h"


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))


extern int NetSendPointSelect();
extern Cdata *CdataSearchByName();


extern NetPort *outP;
extern GC	selGC;
extern Display	*myDpy;
extern int	Swidth, Sheight, Sascent;



void
RubberGlobalPoint(V, w)
	View *V;
	Widget w;
{
	int x, y;
	unsigned int width, height;

	if (V->type == V_RASTER)
	{
		x = V->pt_x;
		y = V->pt_y;
		XDrawLine(myDpy, XtWindow(w), selGC, (x + 1), (y - 2),
                        (x + 9), (y - 2));
		XDrawLine(myDpy, XtWindow(w), selGC, (x + 2), (y - 4),
                        (x + 2), (y - 9));
		XDrawLine(myDpy, XtWindow(w), selGC, (x + 4), (y - 4),
                        (x + 13), (y - 13));
	}
}



void
InitGlobalPoint(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	V->pt_x = win_x + 1;
	V->pt_y = win_y - 1;
	RubberGlobalPoint(V, w);
	if ((V->cData)&&(V->ispub))
	{
		NetSendPointSelect(outP, V->cData->name, "POINTER",
			V->pt_x, V->pt_y);
	}
}


void
GlobalPoint(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	win_x++;
	win_y--;
	if (win_x < 0)
		win_x = 0;
	if (win_y < 0)
		win_y = 0;
	if (win_x >= V->cData->xdim)
		win_x = V->cData->xdim - 1;
	if (win_y >= V->cData->ydim)
		win_y = V->cData->ydim - 1;

	if ((win_x != V->pt_x)||(win_y != V->pt_y))
	{
		if ((V->cData)&&(V->ispub))
		{
			NetSendPointSelect(outP, V->cData->name, "POINTER",
				V->pt_x, V->pt_y);
		}
		RubberGlobalPoint(V, w);
		V->pt_x = win_x;
		V->pt_y = win_y;
		RubberGlobalPoint(V, w);
		if ((V->cData)&&(V->ispub))
		{
			NetSendPointSelect(outP, V->cData->name, "POINTER",
				V->pt_x, V->pt_y);
		}
	}
}


void
DoneGlobalPoint(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int x, y;

	x = V->pt_x;
	y = V->pt_y;

	if ((V->cData)&&(V->ispub))
	{
		NetSendPointSelect(outP, V->cData->name, "POINTER", x, y);
	}
	RubberGlobalPoint(V, w);
}


void
DrawCollabGlobalPoint(title, id, x, y)
	char *title;
	char *id;
	int x, y;
{
	Cdata *d;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		d->V->pt_x = x;
		d->V->pt_y = y;

		if (d->V->isUp)
		{
			RubberGlobalPoint(d->V, d->V->drawArea);
		}
	}
}

