#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include "ud.h"
#include "ud_int.h"
#include "constants.h"
#include "properties.h"




int get_current_serial()
{
 int fd;
 char buff[64];
 
 fd=open(CURRENT_SERIAL_FILE, O_RDONLY, (mode_t)0);
 if (fd < 0) { fprintf(stderr, "cannot open CURRENTERIAL. exiting\n"); exit(1); }
 read(fd, buff, sizeof(buff));
 close(fd);
 return(atoi(buff));
}

int set_current_serial(int current_serial)
{
FILE *file;
 file=fopen(CURRENT_SERIAL_FILE, "w+");
 if (file==NULL) { fprintf(stderr, "cannot open CURRENTERIAL\n"); return(-1); }
 fprintf(file,"%d\n", current_serial);
 fflush(file);
 fclose(file);
 return(0);
}



int do_nrtm=0;

void stop_nrtm(int sig, int code, struct sigcontext *scp)
{
 fprintf(stderr, "NRTM interrupted..\n");
 do_nrtm=0;	
 return;
}
                      



/***********************************************
******* MAIN **********************************
***********************************************/


int main(int argc, char** argv) {
  FILE *file = NULL;
int c;
extern int optind;
extern char *optarg;
int errflg = 0;
int dummy_allowed;
int start_object;
int num_ok, num_failed;
long num_skip=0;
struct _nrtm *nrtm=NULL;
UD_stream_t ud_stream;
int current_serial=-1;
int load_pass=0;
int delay=1;
char *prop_file_name=NULL;

struct sigaction sig;
  
  num_ok=0; num_failed=0;
  dummy_allowed=0;
  
//  strcpy(db_host, "rowan.ripe.net");

  start_object = 1;

	while ((c = getopt(argc, argv, "n:M:L:p:?")) != EOF)
		switch (c) {
		case 'n':
			num_skip=atol(optarg);
			break;	
		case 'M':
			current_serial=atoi(optarg);
			nrtm=calloc(1, sizeof(struct _nrtm));
			break;
		case 'p':
			prop_file_name = optarg;
			break;
		case 'L':
			load_pass=atoi(optarg);
			dummy_allowed=1;
			break;
		case '?':
		default :
			errflg++;
			break;
		}
		if (errflg) {
			fprintf(stderr,"usage: stanalone [-L pass#] [-n num_skip] [-M start_serial] [-p properties] file\n");
			exit (2);
		}


sig.sa_handler=stop_nrtm;
sigemptyset(&sig.sa_mask);
sig.sa_flags=SA_RESTART;
sigaction(SIGINT, &sig, NULL);
sigaction(SIGTERM, &sig, NULL);
do_nrtm=1;

  /* 2. Load properties object from prop_file. */
  fprintf(stderr,"Properties:\n");
  if(prop_file_name==NULL)prop_file_name=".properties";
  PR_load(prop_file_name);
  fprintf(stderr,"%s\n", PR_to_string() );
      
  /* 3. Set the constants. */
  fprintf(stderr,"Constants:\n");
  CO_set();
  fprintf(stderr,"%s\n", CO_to_string() );
            

/* get mode of operation: protected/unprotected (dummy) */
   ud_stream.ud_mode=CO_get_update_mode();
   ud_stream.ud_mode |= dummy_allowed;
                        
/* get database */
ud_stream.db_name=CO_get_database();
                          
/* get database host*/
ud_stream.db_host=CO_get_host();
                            
/* get database port*/
ud_stream.db_port=CO_get_database_port();
                              
/* get database user*/
ud_stream.db_user=CO_get_user();
                                
/* get database password*/
ud_stream.db_pswd=CO_get_password();
                                  
/* get error log facility */
ud_stream.log=CO_get_nrtm_logfile();
                                    
ud_stream.nrtm=nrtm;
                                            
 if(nrtm){
   printf("running as NRTM client\n");

  /* get delay */
	delay=CO_get_nrtm_delay();
    
  /* get mirror server */
	nrtm->server=CO_get_nrtm_host();
      
  /* get mirror port */
	nrtm->port = SK_atoport(CO_get_nrtm_port(), "tcp");
	printf("XXX nrtm_port=%d\n", nrtm->port);
	if(nrtm->port == -1) {
		printf("Invalid service/port: %d\n", nrtm->port);
		exit(-1);
	}
                      
  /* get mirror version */
	nrtm->version=CO_get_nrtm_version();
 }


while(do_nrtm) {
  if(current_serial<0) {// local stream
	if(optind<argc) file=fopen(argv[optind], "r"); else file=stdin;
        do_nrtm=0;
  }
  else
  if(nrtm){
   if(current_serial==0) current_serial=get_current_serial();
   nrtm->current_serial=current_serial;
   fprintf(stderr, "current_serial:\t%d\n", nrtm->current_serial);
   fprintf(stderr, "conecting to server...\n");
   printf("current_serial:\t%d\n", nrtm->current_serial);
   printf("conecting to server...\n");
   
      
   file = get_NRTM_stream(nrtm, 1);
   fprintf(stderr, "OK\n");
   printf("OK\n");
  }


 if (file==NULL) { 	fprintf(stderr, "Cannot open data stream. Exiting..\n");
			exit(1); }


  ud_stream.stream=file;
  ud_stream.num_skip=num_skip;
  ud_stream.load_pass=load_pass;

fprintf(stderr, "starting processing stream\n");
  num_ok=UD_process_stream(&ud_stream);
fprintf(stderr, "processing stream finished\n");  
  if(num_ok<0) exit(1);

  current_serial+=num_ok;
fprintf(stderr, "current serial=%d\n", current_serial); 
printf("Objects received: %d, current_serial=%d\n-----------\n", num_ok, current_serial);
  sleep(delay);
}  

if(current_serial>0)set_current_serial(current_serial);

return(0);

} /* main() */




