/***************************************
  $Revision: 1.4 $

  Error reporting (er) er_facilities.h - list of facilities (modules)

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* this #include is just for cxref to not get lost completely :-) */
#include <erroutines.h>

/* this is the file for adding new facilities.
   This requires three steps:
   1. Prepare and include a file with your error messages (see other files).
	Please follow the filename convention er_??_errors.c 
   2. Declare your facility number in the enum (before the FAC_LAST)

   only when that's ready (for not to prevent other people from working)

   3. Add your facility to the facility table, using the DEFFAC macro
	(it takes a two-letter code and a description of the facility).
	This will add a pointer to the module-specific error table
	to the global table.

   Order of codes in enum does NOT have to match the order of DEFFAC's.
*/

typedef enum {
	FAC_NONE=0,
	FAC_RX, 
	FAC_IP,
	FAC_ER,
	FAC_UT,
	FAC_WH,
	FAC_LAST
} er_fac_code_t;

/* user code for each facility. 
(kept in other files for easy maintenance) */

#include "er_ER_errors.h"
#include "er_IP_errors.h"
#include "er_RX_errors.h"
#include "er_UT_errors.h"
#include "er_WH_errors.h"

/* so much for user code */

#ifndef ER_IMPL
/* just a declaration for modules using this */
#include "erroutines.h"
extern er_main_t *er_main_err;
#else 
  er_main_t 	er_main_err[] = {
	DEFFAC(RX, "radix tree indexing for IP/route objects"),
	DEFFAC(IP, "IP conversion library"),
	DEFFAC(ER, "error system") ,
	DEFFAC(UT, "general utilities and wrappers") ,
	DEFFAC(WH, "embedded whois client") ,
	{FAC_NONE}
  };
#endif /* ER_IMPL */

