/***************************************
  $Revision: 1.5 $

  Wrapper for NRTM client

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include "ud.h"
#include "ud_int.h"
#include "constants.h"



int get_current_serial()
{
 int fd;
 char buff[64];
 const char *filename;
 
 filename=CO_get_nrtm_cserialfile();
 fd=open(filename, O_RDONLY, (mode_t)0);
 if (fd < 0) { fprintf(stderr, "cannot open %s\n", filename); return(-1); }
 read(fd, buff, sizeof(buff));
 close(fd);
 return(atoi(buff));
}

int set_current_serial(int current_serial)
{
FILE *file;
const char *filename;

 filename=CO_get_nrtm_cserialfile();
 file=fopen(filename, "w+");
 if (file==NULL) { fprintf(stderr, "cannot open %s\n", filename); return(-1); }
 fprintf(file,"%d\n", current_serial);
 fflush(file);
 fclose(file);
 return(0);
}


/*************************************
*
*
**************************************/

void UD_do_nrtm()
{
UD_stream_t ud_stream;
struct _nrtm *nrtm=calloc(1, sizeof(struct _nrtm));
//int dummy_allowed;
int delay;
int do_nrtm=1;
FILE *file, *logfile;
int num_ok;
int upto_last;


/* get mode of operation: protected/unprotected (dummy) */
  ud_stream.ud_mode=CO_get_update_mode();

  fprintf(stderr, "Mode of operation:\n");
  if(IS_DUMMY_ALLOWED(ud_stream.ud_mode))fprintf(stderr, "* dummy allowed\n"); 
   else fprintf(stderr, "* dummy not allowed\n");
  if(IS_UPDATE(ud_stream.ud_mode))fprintf(stderr, "* DBupdate\n");
   else fprintf(stderr, "* NRTM\n");
  if(IS_STANDALONE(ud_stream.ud_mode))fprintf(stderr, "* running standalone\n");
   else fprintf(stderr, "* running as a server\n");
  
/* get mirror server */
  nrtm->server=CO_get_nrtm_host();
  
/* get mirror port */
  nrtm->port = SK_atoport(CO_get_nrtm_port(), "tcp");
  printf("XXX nrtm_port=%d\n", nrtm->port);
  if(nrtm->port == -1) {
    printf("Invalid service/port: %d\n", nrtm->port);
    exit(-1);
  }
              
/* get mirror version */
  nrtm->version=CO_get_nrtm_version();
  
/* get database */
  ud_stream.db_name=CO_get_database();
  
/* get database host*/
  ud_stream.db_host=CO_get_host();

/* get database port*/
  ud_stream.db_port=CO_get_database_port();
    
/* get database user*/
  ud_stream.db_user=CO_get_user();
  
/* get database password*/
  ud_stream.db_pswd=CO_get_password();

/* get error log facility */
  ud_stream.log=CO_get_nrtm_logfile();
  
//  ud_stream.dummy_allowed=dummy_allowed;
  ud_stream.num_skip=0;
  ud_stream.load_pass=0;
  ud_stream.nrtm=nrtm;
  
  upto_last=0; // let's start gradually if the backlog is > SBUNCH (1000) serials

/*+++ main cycle +++*/

 while(do_nrtm=CO_get_do_nrtm()) {

/* get current serial */
  nrtm->current_serial=get_current_serial();
  if(nrtm->current_serial == -1) {
    printf("Error obtaining current serial: %d\n", nrtm->current_serial);
    exit(-1);
  }

   fprintf(stderr, "current_serial:\t%d\n", nrtm->current_serial);
   fprintf(stderr, "conecting to server...\n");
   printf("current_serial:\t%d\n", nrtm->current_serial);
   printf("conecting to server...\n");
      
   file = get_NRTM_stream(nrtm, upto_last);
   fprintf(stderr, "OK\n");
   printf("OK\n");


  if (file==NULL) { 
    fprintf(stderr, "Cannot open data stream. Trying...\n");
    sleep(100);
    continue;
  }  


  ud_stream.stream=file;

fprintf(stderr, "starting processing stream\n");

  num_ok=UD_process_stream(&ud_stream);
  
  
fprintf(stderr, "processing stream finished\n");  
  if(num_ok<0) exit(1);

/* Now we can process serials in normal way */ 
  if(num_ok==0) upto_last=1;

  set_current_serial(nrtm->current_serial+num_ok);
logfile = fopen(ud_stream.log, "a+");
fprintf(logfile, "forwarded to serial:\t%d\n", nrtm->current_serial+num_ok);
fclose(logfile);
fprintf(stderr, "forwarded to serial:\t%d\n", nrtm->current_serial+num_ok);
printf("Objects received: %d\n-----------\n", num_ok);

/* get delay */
  delay=CO_get_nrtm_delay();

  if (do_nrtm) sleep(delay);
 }
 
 if(nrtm) free(nrtm);
 
 fprintf(stderr, "NRTM stopped\n");  

} /* UD_do_nrtm() */



/*************************************
*
*
**************************************/
  
void UD_do_updates(void *arg)
{
int listening_socket = (int)arg;
int connected_socket;
UD_stream_t ud_stream;
int dummy_allowed;
int delay;
int do_update=1;
FILE *file, *file_ack, *logfile;
int num_ok;


/* get mode of operation: protected/unprotected (dummy) */
  ud_stream.ud_mode=CO_get_update_mode();

  fprintf(stderr, "Mode of operation:\n");
  if(IS_DUMMY_ALLOWED(ud_stream.ud_mode))fprintf(stderr, "* dummy allowed\n"); 
   else fprintf(stderr, "* dummy not allowed\n");
  if(IS_UPDATE(ud_stream.ud_mode))fprintf(stderr, "* DBupdate\n");
   else fprintf(stderr, "* NRTM\n");
  if(IS_STANDALONE(ud_stream.ud_mode))fprintf(stderr, "* running standalone\n");
   else fprintf(stderr, "* running as a server\n");

  
/* get database */
  ud_stream.db_name=CO_get_database();
  
/* get database host*/
  ud_stream.db_host=CO_get_host();

/* get database port*/
  ud_stream.db_port=CO_get_database_port();
    
/* get database user*/
  ud_stream.db_user=CO_get_user();
  
/* get database password*/
  ud_stream.db_pswd=CO_get_password();

/* get error log facility */
  ud_stream.log=CO_get_nrtm_logfile();
  

  ud_stream.num_skip=0;
  ud_stream.load_pass=0;
  ud_stream.nrtm=NULL;
  
/*+++ main cycle +++*/

 while(do_update=CO_get_do_update()) {

/* accept connection */
   connected_socket = SK_accept_connection(listening_socket);
   file=fdopen(connected_socket, "r");
   file_ack=fdopen(connected_socket, "w");

   fprintf(stderr, "Connection accepted...\n");
   
  if (file==NULL) { 	fprintf(stderr, "Cannot open data stream. Exiting..\n");
			exit(-1); }


  ud_stream.stream=file;

fprintf(stderr, "starting processing object\n");

  num_ok=UD_process_stream(&ud_stream);
  
fprintf(stderr, "processing object finished\n");  

  if(num_ok==1) fprintf(file_ack, "%%ERROR 0\n");
   else {
      num_ok=(-1)*num_ok;
      fprintf(file_ack, "%%ERROR %d\n",num_ok);
      fprintf(file_ack, "Transaction had the following problems:\n");
      if(num_ok & ERROR_U_MEM) fprintf(file_ack, "Memory allocation error\n");
//      if(num_ok & ERROR_U_DBS) fprintf(file_ack, "Database (SQL) error\n");
//      if(num_ok & ERROR_U_OBJ) fprintf(file_ack, "Object (RF) error\n");
//      if(num_ok & ERROR_U_AUT) fprintf(file_ack, "Object authentication error\n");
      if(num_ok & ERROR_U_BADOP) fprintf(file_ack, "Bad operation\n");
      if(num_ok & ERROR_U_COP) fprintf(file_ack, "Conflicting operation\n");
      if(num_ok & ERROR_U_NSUP) fprintf(file_ack, "Object of this type is not supported\n");
      if(num_ok & ERROR_U_BUG) fprintf(file_ack, "Software bug - report to <ripe-dbm@ripe.net>\n");
      if(ud_stream.error_script)fprintf(file_ack, "%s\n", ud_stream.error_script);
   }
   
   if(ud_stream.error_script) free(ud_stream.error_script);
   fclose(file_ack);   

 } /* while do_update */
 
 
 fprintf(stderr, "server stopped\n");  

} /* UD_do_update() */




