#       dbmatch - looks up the offsets in the dbm file
#
#	$RCSfile: dbmatch.pl,v $
#	$Revision: 1.2 $
#	$Author: marten $
#	$Date: 1994/09/20 11:41:44 $
#
#	looks up the offsets in the dbm file for all keys
#       and will return an array with the intersection of all
#       offsets of all keys
#

sub dbmatch {

    local(*db, *keys, $nonintersect) = @_;

    local($os) = "";
    local(@tmp2);
    local($tmp);
    local(@result);
    local(@offsets);
    local($toomany) = -1;
    local($xsps) = "";

    foreach (@keys) {
	next if (!($os = $db{$_}));
	if ($os == -1) {
	    $toomany++;
	    next;
	}
	if ($os) {
	    @offsets = (split(/\,/, $os));
	}

	if ($nonintersect) {
	    @result = (@result, @offsets);
	} else {
	    if (($#result > -1)) {
		local(%tmp);
		grep($tmp{$_}++, @offsets);
		@tmp2 = @result;
		@result = grep($tmp{$_}, @tmp2);
	    }
	    else {
		@result = @offsets;
	    }
	}
    }
    if (($toomany == $#keys) && ($toomany != -1)) {
	$result[0] = -1;
    }
    return @result;
}

1;
