#       enkeys - extract keys from entry
#
#	$RCSfile: enkeys.pl,v $
#	$Revision: 0.18 $
#	$Author: marten $
#	$Date: 1994/11/02 18:12:49 $
#

require "misc.pl";
require "cldb.pl";

sub enkeys {

    local(*e) = @_;
    local(@keys);

    $type = &entype(*e);

    foreach (split(/\s+/, $KEYS{$type})) {
	$value = $e{$_};
	if ($value =~ /[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+/) {
	    @keys = (@keys, &getipkeys($value));
	}
	else {
	    @keys = (@keys, &getalkeys($value));
	}
    }
    return @keys;
}


sub getalkeys {
    local ($value) = @_;
    local ($i, @result);

    @result = split(/\s+/, $value);
    $i = $#result;
    while ($i >= 0) {
	$result[$i] =~ tr/A-Z/a-z/;
	$result[$i] =~ tr/a-z0-9\-,\._'\///cd;
        #' quote to fool emacs perl mode
	if (length($result[$i])<2) {
	    splice(@result, "$i", 1);
	}
	$i--;
    }
    return @result;
}

sub getipkeys {
    local($value) = @_;
    local(@ipkeys) = ();
    local($counter) = 0;

    foreach (split(/\n/, $value)) {
	foreach (&old_to_new($_)) {
	    $ipkeys[$counter++] = $_;
	}
    }
    return @ipkeys;
}

#
# Old routine, before cldb era.
#
#sub getipkeys {
#    local ($value) = @_;
#    local ($i, $inc, @result);
#
#    @result = split(/\s+/, $value);
#    if ($#result == 0) {
#	$result[0] = &trailzero($result[0]);
#	return @result;
#    }
#
#    local($lo, $hi) = (&quad2int($result[0]), &quad2int($result[2]));
#    $result[0] = &trailzero($result[0]) . "-" . &trailzero($result[2]);
#
#    $inc = 256 if ($lo < &quad2int("224.0.0.0"));
#    $inc = 256**2 if ($lo < &quad2int("192.0.0.0"));
#    $inc = 256**3 if ($lo < &quad2int("128.0.0.0"));
#
#    
#    for ($i=$lo; $i<=$hi; $i+=$inc) {
#	@result = (@result, &trailzero(&int2quad($i)));
#    }
#    splice(@result,1,2);
#    return @result;
#}

1;
