
#	$RCSfile: notify.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

#
# notify.pl - implements the notify function.

require "encmp.pl";
require "enwrite.pl";
require "entype.pl";

# It consists of two parts. One is the part that writes out the objects
# to temp files, one temp file per notifier, and this is called from
# updatecheck, the second part should be called at the end of an update
# from dbupdate, and will actually mail out the notify messages.

sub AddNotify {
    local(*old, *new) = @_;

    #
    # add guardians in case they happen to exist for
    # backward compatibility

    if (($old{"ny"}) || ($old{"gd"})) {
       
       local(@notifiers)=split(/\n+/, $old{"ny"}."\n".$old{"gd"});
	
       &DoAddNotify(*notifiers, *old, *new) if (scalar(@notifiers));
    
    }
    elsif ((!%new) && (($new{"ny"}) || ($new{"gd"}))) {
    
       local(@notifiers)=split(/\n+/, $new{"ny"}."\n".$new{"gd"});
	
       &DoAddNotify(*notifiers, *old, *new) if (scalar(@notifiers));
    
    }
    
}

sub DoAddNotify {
    local(*notifiers, *old, *new) = @_;

    local($notify, $regularnotify);
    local(%notifiers)=();
    
    foreach $notify (@notifiers) {
        
        print STDERR "notifier: $notify\n" if ($opt_V);
        
        #
        # skip doubles
        
        next if ((!$notify) || ($notifiers{$notify}));
        $notifiers{$notify}=1;
        
        #
        # skip people that already get the ACK message
        
        $regularnotify=&MakeRegular($notify);
        next if ($REPLYTO=~ /$regularnotify/);
    
	if (!$notify{$notify}) {
	    $notify{$notify} = &NotifyTmpFile($notify);
	    open(NOTIFY, ">".$notify{$notify}) ||
		&syslog("ERRLOG", "Cannot create notify file $notify{$notify}");
	    &WriteNotifyHeader(NOTIFY, $notify);
	}
	else {
	    open(NOTIFY, ">>".$notify{$notify}) ||
		&syslog("ERRLOG", "Cannot open notify file $notify{$notify}");
	}
	
	print NOTIFY "---\n";
	
	if (!%new) { # Deletion
	   print NOTIFY "OBJECT BELOW DELETED:\n";
	   &enwrite(NOTIFY,*old,1,0,1);
	}
	elsif (!%old) {
	   print NOTIFY "OBJECT BELOW CREATED:\n";
	   &enwrite(NOTIFY,*new,1,0,1);
	}
	else {
	   print NOTIFY "PREVIOUS OBJECT:\n";
	   &enwrite(NOTIFY,*old,1,0,1);
	   print NOTIFY "\nREPLACED BY:\n";
	   &enwrite(NOTIFY,*new,1,0,1);
	}
	
	print NOTIFY "\n";
	
	close(NOTIFY);
    
    }

}


sub NotifyTmpFile {

    return $TMPDIR."\/".$_[0].".".$$;
    
}

sub WriteNotifyHeader {
    local($filehandle, $notifier)=@_;

    $notifier=$DEFMAIL if $TESTMODE;
    
    print $filehandle $NHEADER, "To: ", $notifier, "\n\n", $NOTITXT;
    
    if ($NETWORKUPDATE) {
       print $filehandle $NOTINETWORKTXT, "\n";
    }
    else {
       print $filehandle $NOTIMAILTXT, "\n";
    }
    
}    


sub SendNotifications {

    foreach (values %notify) {
       system("$MAILCMD < $_");
       print STDERR "notify: $_\n" if ($opt_V);
    }
    
    unlink(values %notify);
    
    %notify=();
    
}
