/* tcp.h */

#define SOCK_STREAM     1
#define SOL_SOCKET      0xffff
#define SO_REUSEADDR    0x0004
#define AF_INET         2
#define FIONBIO         0x667e
#define INADDR_ANY      0UL

typedef unsigned short u_short;
typedef char *caddr_t;

struct sockaddr
{
  u_short sa_family;
  char sa_data[14];
};

struct hostent
{
  char *h_name;
  char **h_aliases;
  int h_addrtype;
  int h_length;
  char **h_addr_list;
};

#define h_addr h_addr_list[0]

struct servent
{
  char *s_name;
  char **s_aliases;
  int s_port;
  char *s_proto;
};

struct in_addr
{
  unsigned long s_addr;
};

struct sockaddr_in
{
  short sin_family;
  unsigned short sin_port;
  struct in_addr sin_addr;
  char sin_zero[8];
};


int bind (int s, struct sockaddr *name, int namelen);
unsigned short bswap (unsigned short x);
int connect (int s, struct sockaddr *name, int namelen);
struct hostent *gethostbyname (const char *name);
struct servent *getservbyname (const char *name, const char *proto);
int soioctl (int handle, int request, ...);
int recv (int s, void *buf, int len, int flags);
int send (int s, const void *msg, int len, int flags);
int setsockopt (int s, int level, int optname, char *optval, int optlen);
int socket (int domain, int type, int protocol);
int soclose (int s);

#define htons(X) bswap (X)
