/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */

/*
 *	File:		gr_fillev.c
 *	Contents:	File level window functions for graphics module
 */

#include "gr_com.h"

extern void gr_SDSLoad();  /* put this in gr_ext.h someday */
#define ORGX	400
#define ORGY	350

static  char gr_ChangeDirTrans[] = "<Key>Return:    gr_FileDirReturn()";
static  char gr_SaveFileTrans[]  = "<Key>Return:    gr_FileSaveReturn()";

time_t	lastMod, lastDirMod;

/* #ifdef XIMAGE_PALETTE Now, chosen at run time. gbourhis Feb 93 
void	gr_SavePal();		unused in this file.
   #endif  */

/*
 *	Initialize File Window
 */
A_FileWind_t
*gr_InitFileLevel(shellName,parent)
char *shellName;
Widget parent;
{
	A_FileWind_t *tmp;
	Widget		boxWind;
#ifdef MIRIADFMT
	Widget		RCWind;
#endif

	if ((tmp = (A_FileWind_t *)td_Malloc(sizeof(A_FileWind_t),
			   "A_FileWind_t")) == NULL)
		return(NULL);

	if ((tmp->fileData = td_FileDirStrings(td_getDirName())) == NULL)
		return(NULL);

	/* Update last modification time of current directory */
	td_setDirName(td_getDirName());

	tmp->shell = gr_MakeWindow("XDS File Window",parent,&(tmp->win),
					(XtCallbackProc)gr_CloseFileLevel,
					FILEWIND,"File Window","Cancel",(caddr_t)tmp,
					ORGX,ORGY,304,350);

	boxWind = gr_MakeBulletin("XDSbox",tmp->win,2,2,310,60);  /* 310, wuz 293 */

		tmp->dirDialog = gr_MakeDialog("XDSdialog",boxWind,
			"Current Working Directory:             ",
			td_getDirName(),256,2,2,238,50);
		gr_DialogAddTrans(tmp->dirDialog,gr_ChangeDirTrans);

	tmp->savBox=	gr_MakeButton("XDSbutton",boxWind,"Up",
			(XtCallbackProc)gr_FileDirUp,(caddr_t)tmp,
			245,2,45,50);


#ifdef RIOS
    Strcpy(gr_FileName,gr_FileGetFileStrng(tmp->fileData[0]));
#else
    strcpy(gr_FileName,gr_FileGetFileStrng(tmp->fileData[0]));
#endif

	boxWind = gr_MakeBulletin("XDSbox",tmp->win,2,62,293,60);

/* ** new . added jng 0ct - 8 */
		tmp->fileDialog = gr_MakeDialog("XDSdialog",boxWind,
			"Current Filename:               ",
			gr_FileName,STRNG160,2,2,238,50); 

		gr_DialogAddTrans(tmp->fileDialog,gr_SaveFileTrans);

		tmp->saveButton = gr_MakeButton("XDSbutton",boxWind,"SAVE",
			(XtCallbackProc)gr_FileSave,(caddr_t)tmp,
			245,2,45,50);

	tmp->fileWin = gr_MakeList("XDSlist",tmp->win, &(tmp->fileVPort),
			VERTONLY,1,20,NULL,NULL,(XtCallbackProc)gr_FileCheck,
			tmp->fileData,(caddr_t)tmp,2,128,150,185);

	boxWind = gr_MakeBulletin("XDSbulletin",tmp->win,155,128,140,60);
		tmp->sdsDialog = gr_MakeDialog("XDSdialog",boxWind,
			"SDS #","1",STRNG160,2,2,50,50);
		tmp->scaleDialog = gr_MakeDialog("XDSdialog",boxWind,
			"SCALE","1",STRNG160,52,2,50,50);
		tmp->rasStartDialog = gr_MakeDialog("XDSdialog",boxWind,
			"Start ","-",STRNG160,2,2,68,50);
		tmp->rasEndDialog = gr_MakeDialog("XDSdialog",boxWind,
			"End   ","-",STRNG160,70,2,68,50);
		tmp->saveSepToggle = gr_MakeToggle("XDStoggle",boxWind,
			"Save separately",SQUARE,
			FALSE,(XtCallbackProc)gr_FileSetSeparate,
			(XtCallbackProc)gr_FileSetSingle,
			(caddr_t)tmp,2,2,130,30);

	tmp->sdsBox = gr_MakeBox("XDSbox",tmp->win,155,185,140,126);
		gr_MakeButton("XDSbutton",tmp->sdsBox,"LOAD SDS",
			(XtCallbackProc)gr_SDSLoad,(caddr_t)tmp,
			2,2,130,22);

		gr_MakeToggle("XDStoggle",tmp->sdsBox,"Load all SDSs",SQUARE,
			FALSE,(XtCallbackProc)gr_FileSetLoadAll,
			(XtCallbackProc)gr_FileSetLoadSingle,
			(caddr_t)tmp,2,26,130,20);
#ifdef MIRIADFMT
		RCWind = gr_MakeRowColumn("XDSrowcolumn",tmp->sdsBox,ONEOFMANY,1,
			0,32,148,78);
		gr_MakeToggle("XDStoggle",RCWind,"HDF format",DIAMOND,
			TRUE,(XtCallbackProc)gr_FileUseHDF,
			NULL,(caddr_t)tmp,2,2,125,20);
		gr_MakeToggle("XDStoggle",RCWind,"FITS format",DIAMOND,
			FALSE,(XtCallbackProc) NULL,
			NULL,(caddr_t)tmp,2,25,125,20);
		gr_MakeToggle("XDStoggle",RCWind,"Miriad format",DIAMOND,
			FALSE,(XtCallbackProc)gr_FileUseMiriad,
			NULL,(caddr_t)tmp,2,45,125,20);
#endif
	tmp->palBox = gr_MakeBox("XDSbox",tmp->win,155,190,140,123);
		gr_MakeButton("XDSbutton",tmp->palBox,"LOAD PALETTE",
			(XtCallbackProc)gr_PalletLoad,(caddr_t)tmp,
			2,2,130,30);
/* #ifdef XIMAGE_PALETTE */
	if (gr_Data.paletteEditor) /* gbourhis Feb 93 */
	  {
	    tmp->palSaveBox = gr_MakeBox("XDSbox",tmp->win,155,190,140,123);
	    gr_MakeButton("XDSbutton",tmp->palSaveBox,"SAVE PALETTE",
			  (XtCallbackProc)gr_FileSave,(caddr_t)tmp,
			  2,2,130,30);
	/* Change to use gr_SavePalSplit once there is one??? */
	    tmp->palSplitSaveBox = NULL; /* disable use of this */
/*
	tmp->palSplitSaveBox = gr_MakeBox("XDSbox",tmp->win,155,190,140,123);
		gr_MakeButton("XDSbutton",tmp->palSaveBox,"SAVE PALETTE",
			(XtCallbackProc)gr_SavePal,(caddr_t)tmp,
			2,2,130,30);
*/
	  }
/* #endif */

	gr_MakeToggle("XDStoggle",tmp->palBox,"Global Change",SQUARE,
		      FALSE,(XtCallbackProc)gr_FileSetGlobal,
		      (XtCallbackProc)gr_FileSetLocal,
		      (caddr_t)tmp,2,35,130,30);
	tmp->palSBox = gr_MakeBox("XDSbox",tmp->win,155,190,140,123);
	gr_MakeButton("XDSbutton",tmp->palSBox,"LOAD PALETTE",
		      (XtCallbackProc)gr_PalletLoadSplit,(caddr_t)tmp,
		      2,2,130,30);
	tmp->rasBox = gr_MakeBox("XDSbox",tmp->win,155,190,140,123);
	gr_MakeButton("XDSbutton",tmp->rasBox,"ANIMATE RASTER8",
		      (XtCallbackProc)gr_AniLoad,(caddr_t)tmp,
		      2,2,130,30);
	DBPRINTARG("SDSload callback init tmp is %x\n", tmp);

/* Cannot use pixmaps on the IRIS */
#ifdef IRIS
	tmp->usePixmap = FALSE;
#else
	if (gr_Data.useXImage == FALSE)
		tmp->usePixmap = TRUE;
	else
		tmp->usePixmap = FALSE;
#endif

		gr_MakeToggle("XDStoggle",tmp->rasBox,"Use Pixmaps",SQUARE,
			tmp->usePixmap,(XtCallbackProc)gr_FileUsePixmap,
			(XtCallbackProc)gr_FileUseXImage,
			(caddr_t)tmp,2,35,130,20);
		gr_MakeToggle("XDStoggle",tmp->rasBox,"Animate from Disk",SQUARE,
			FALSE,(XtCallbackProc)gr_FileUseDisk,
			(XtCallbackProc)gr_FileUseMemory,
			(caddr_t)tmp,2,58,130,20);

	tmp->separateFiles = FALSE;
	tmp->globalPalette = FALSE;
	tmp->loadAllSDS = FALSE;
	tmp->format = HDF;
	tmp->useDisk = FALSE;

	DBPRINT("done with gr_InitFileLevel\n");
	return(tmp);
}


/*
 *	Hide File Window
 */
void
gr_FileHideLevel(fileWin)
A_FileWind_t	*fileWin;
{
	XtUnmapWidget(fileWin->saveButton);
	XtUnmapWidget(fileWin->sdsDialog);
	XtUnmapWidget(fileWin->scaleDialog);
	XtUnmapWidget(fileWin->rasStartDialog);
	XtUnmapWidget(fileWin->rasEndDialog);
	XtUnmapWidget(fileWin->saveSepToggle);
	XtUnmapWidget(fileWin->sdsBox);
	XtUnmapWidget(fileWin->palBox);
	XtUnmapWidget(fileWin->palSBox);
/* #ifdef XIMAGE_PALETTE */
	if (gr_Data.paletteEditor) /* gbourhis Feb 93 */
	  {
	    XtUnmapWidget(fileWin->palSaveBox);
	    /* May or not be here depending on state of development in
	       gr_InitFileLevel
	       */
	    if(fileWin->palSplitSaveBox != NULL)
	      XtUnmapWidget(fileWin->palSplitSaveBox);
	  }
/* #endif */
	XtUnmapWidget(fileWin->rasBox);
	XtUnmapWidget(fileWin->shell);
}


/*
 *	Show File Window corresponding to fileaction
 */
void
gr_FileShowLevel(fileaction)
A_FileAction_t	fileaction;
{
	A_FileWind_t	*fileWin=gr_topWin.fileWin;
	Widget		labelWid=XtNameToWidget(fileWin->shell,"XDSbulletin.XDSlabel");
	char		label[80];

	DBPRINT("IN gr_FileShowLevel\n");

	gr_WidgetCursor(gr_topLevel,XC_watch);

	sprintf(msg,"%s/.",td_getDirName());
	td_FileIsDir(msg,&lastMod);
	if (lastMod != lastDirMod)
	{
		gr_TextMsgOut("\nContents of current working directory has been changed.\n");
		gr_TextMsgOut("Please wait while File List is rehashed...\n");
		gr_FileDirAccept(fileWin,td_getDirName());
		DBPRINT("ret from  gr_FileDirAccept\n");
		gr_TextMsgOut("Rehashing completed.\n\n");
	}

	switch (fileaction)
	{
	      case LOADRAS :
		gr_TextMsgOut
		("\nSelect a HDF RASTER8 file and click the ANIMATE RASTER8\n");
		gr_TextMsgOut
		("button to load all frames into memory for animation.\n");
		sprintf(label,"Load a RASTER8 set");
		break;

	      case LOADSDS :
		gr_TextMsgOut
		("\nSelect a 3D SDS file, and input the ID of the SDS in the\n");
		gr_TextMsgOut
		("file that you wish to load into memory.  If you wish to load\n");
		gr_TextMsgOut
		("all the SDSs in the file, turn on the Load All SDSs toggle.\n");
		gr_TextMsgOut
		("Click on the LOAD SDS button to load the dataset/s.\n");
		sprintf(label,"Load a SCIENTIFIC set");
		break;

	      case LOADPAL :
		gr_TextMsgOut
		("\nSelect a HDF/SEQ palette file, and click on the LOAD PALETTE\n");
		gr_TextMsgOut
		("button to change the color map.  If the Global Change toggle is\n");
		gr_TextMsgOut
		("switched on, the color map will be loaded into all previously\n");
		gr_TextMsgOut
		("opened raster image windows.\n");
		sprintf(label,"Load a color map");
		break;

	      case LOADPALSPLIT :
		gr_TextMsgOut
		("\nSelect a HDF/SEQ palette file, and click on the LOAD PALETTE\n");
		gr_TextMsgOut
		("button to change the color map.  If the Global Change toggle is\n");
		gr_TextMsgOut
		("switched on, the color map will be loaded into all previously\n");
		gr_TextMsgOut
		("opened image windows.  Note that the palette will be split into\n");
		gr_TextMsgOut
		("3 equal portions for use by the Dicer Window.\n");
		sprintf(label,"Split a color map");
		break;

	      case SAVEANI :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the animation\n");
		gr_TextMsgOut
		("sequence and click on the Save Button to save the sequence of\n");
		gr_TextMsgOut
		("of images.  You may also select a filename out of the File\n");
		gr_TextMsgOut
		("List so to append the sequence to the contents of the file.\n");
		sprintf(label,"Save animation frames");
		break;

	      case SAVEDICER :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the Dicer image\n");
		gr_TextMsgOut
		("and click on the Save Button to save the image.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the image to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save a Dicer image");
		break;

	      case SAVEDISKA :
	      case SAVEDISKP :
	      case SAVEDISKI :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the Animation\n");
		gr_TextMsgOut
		("sequence and click on the Save Button to save the image.  You\n");
		gr_TextMsgOut
		("may also select a filename out of the File List to append the\n");
		gr_TextMsgOut
		("images to the end of the contents of the selected file.\n");
		sprintf(label,"Save an Animation sequence");
		break;

	      case SAVEDSPL :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the raster\n");
		gr_TextMsgOut
		("and click on the Save Button to save the image.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the image to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save a display frame");
		break;

	      case SAVEISO :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the raster\n");
		gr_TextMsgOut
		("and click on the Save Button to save the image.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the image to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save an Iso-surface Image");
		break;

	      case SAVEPROC :
		gr_TextMsgOut
		("\nSelect the 3D HDF SDS file containing the dataset to be\n");
		gr_TextMsgOut
		("interpolated and input the filename of the HDF to which the\n");
		gr_TextMsgOut
		("enlarged dataset is to be stored.  Click on Save to start the\n");
		gr_TextMsgOut
		("process which will save the dataset automatically when done.\n");
		sprintf(label,"Process & save a SDS");
		break;

	      case SAVETILE :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing all the images\n");
		gr_TextMsgOut
		("and click on the Save Button to save the images.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the images to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save tile frames");
		break;

	      case SAVEVIEW :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the image\n");
		gr_TextMsgOut
		("and click on the Save Button to save the image.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the image to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save an oblique frame");
		break;

	      case SAVEVBUFF :
		gr_TextMsgOut
		("\nInput the filename of the HDF file for storing the VBuff image\n");
		gr_TextMsgOut
		("and click on the Save Button to save the image.  You may also\n");
		gr_TextMsgOut
		("select a filename out of the File List to append the image to\n");
		gr_TextMsgOut
		("the end of the contents of the file.\n");
		sprintf(label,"Save a VBuff image");
		break;

/* #ifdef XIMAGE_PALETTE */
	      case SAVEPAL:
	      case SAVEPALSPLIT:
		gr_TextMsgOut ("\nSelect a file name to save the palette to.\n");
		sprintf(label,"Save a color map");
		break;

	      default:
		gr_TextMsgOut ("using file selected from command line\n");
		break;
			
/* #endif */
	}

	gr_TextMsgOut("Click Cancel to abort the File Window...\n");
	
	DBPRINTARG("gr_FileShowLevel: setting label [%s]\n", label);
	gr_LabelSetValue(labelWid,label);

	XtMapWidget (fileWin->shell);

	XRaiseWindow(XtDisplay(fileWin->savBox), XtWindow(fileWin->savBox));

	if ((fileaction == SAVEANI) || (fileaction == SAVEDSPL) ||
		(fileaction == SAVEDISKA) || (fileaction == SAVEDISKP) ||
		(fileaction == SAVEDISKI) ||
		(fileaction == SAVEPROC) || (fileaction == SAVEDICER) ||
		(fileaction == SAVETILE) || (fileaction == SAVEVIEW) ||
		(fileaction == SAVEVBUFF) || (fileaction == SAVEISO)
/* #ifdef XIMAGE_PALETTE
		|| (fileaction == SAVEPAL) || (fileaction == SAVEPALSPLIT)
/* #endif Commented: use palSaveBox (gbourhis Feb 93) */
		 )
	{
		XtMapWidget(fileWin->saveButton);
		XRaiseWindow(XtDisplay(fileWin->saveButton),
			     XtWindow(fileWin->saveButton));
	}

	if ((fileaction == LOADSDS) || (fileaction == SAVEPROC)) 
	{
		XtMapWidget(fileWin->sdsDialog);
		if (fileaction == SAVEPROC)
			XtMapWidget(fileWin->scaleDialog);
    }

	if (fileaction == LOADRAS )
	{
		DBPRINT("mapping widgets rasStartDialog and rasEndDialog\n");
		XtMapWidget(fileWin->rasStartDialog);
		XtMapWidget(fileWin->rasEndDialog);
    }

	if (fileaction == SAVEANI)
	{
		XtMapWidget(fileWin->saveSepToggle);
	}

	if ((fileaction == LOADSDS) || (fileaction == LOADPAL) || 
		(fileaction == LOADPALSPLIT) || (fileaction == LOADRAS) ||
		(fileaction == SAVEPAL) || (fileaction == SAVEPALSPLIT))
	{
		if (fileaction == LOADSDS)
		{
			XtMapWidget(fileWin->sdsBox);
		}
		else
		if (fileaction == LOADPAL)
		{
			XtMapWidget(fileWin->palBox);
		}
		else
		if (fileaction == LOADPALSPLIT)
		{
			XtMapWidget(fileWin->palSBox);
		}
		else
		if (fileaction == LOADRAS)
		{
			XtMapWidget(fileWin->rasBox);
		}
/* #ifdef XIMAGE_PALETTE */
		else
		if (fileaction == SAVEPAL)
		{
			XtMapWidget(fileWin->palSaveBox);
		}
		else
		if (fileaction == SAVEPALSPLIT &&
		    fileWin->palSplitSaveBox != NULL)
		{
			XtMapWidget(fileWin->palSplitSaveBox);
		}
/* #endif */
	}

	gr_ListHighlight(fileWin->fileWin,0);

	gr_WidgetCursor(fileWin->shell,XC_draped_box);
	gr_WidgetCursor(gr_topLevel,XC_draped_box);
}


/*
 * Close File Window
 */
void
gr_CloseFileLevel(w, client_data, call_data)
Widget	w;
caddr_t	client_data;
caddr_t	call_data;
{
	A_FileWind_t	*fileWin=gr_topWin.fileWin;

	if (fileWin != NULL)
	{
		gr_FileHideLevel(fileWin);
		gr_topWin.numFileWins--;
	}
}


/*
 *	Destroy File Window
 */
void
gr_DestroyFileLevel()
{
	A_FileWind_t	*fileWin=gr_topWin.fileWin;

	if (fileWin != NULL)
	{
		td_Free2d((char **)fileWin->fileData);
		XtDestroyWidget(fileWin->shell);
	}
}
