/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */

/*
 *	File:		gr_hislev.c
 *	Contents:	Histogram level window functions for graphics module
 */

#include "gr_com.h"

#define MINHISTXSIZE	50
#define MINHISTYSIZE	100
#define	MAXHISTXSIZE	900
#define	MAXHISTYSIZE	900
#define	LEEWAY			2
#define XORIGIN			40
#define XOFFSET			40
#define YOFFSET			30
#define YFUDGE 30  /* jng nov 26 jjj */

/* ------------------------------------------------------------------ */
/*
 *	Return a Hist window for an arbitrary slice of data
 */
A_HistWind_t
*gr_InitHistLevel(header,shellName,parent,tparent)
A_HistWind_t *header;
char   	 *shellName;
Widget	 parent;
A_DsplWind_t	*tparent;
{
	A_Axes_t		orient;
	A_HistWind_t	*tmp;
	int				xsize,ysize,winxsize,winysize;
	int				xaxis,yaxis;
	char				label[STRNG80];
	int 			*  gr_HistPrint();
	Widget      boxWind;

	gr_WidgetCursor(tparent->shell,XC_watch);

	orient = tparent->axesOrient;
    if (orient.col < 0)
		xaxis = -orient.col;
	else 
		xaxis = orient.col;
	if (orient.row < 0)
		yaxis = -orient.row;
	else
		yaxis = orient.row;

	sprintf(label,"%s: (%s%d,%s%d)",
		tparent->parent->parent->filename,
		axesLabels[xaxis-1],tparent->selX,
		axesLabels[yaxis-1],tparent->selY);

	if ((tmp = (A_HistWind_t *)td_Malloc(sizeof(A_HistWind_t),
			   "A_HistWind_t")) == NULL)
		return(NULL);

	tmp->xpos = tparent->selX;
	tmp->ypos = tparent->selY;

/* jng: fix so that all planes are displayed in the histogram */
	tmp->xsize = xsize = (tparent->zdim)
                 *tparent->width+2*XOFFSET;

	tmp->ysize = ysize = gr_color.nColors+2*YOFFSET;

    if (xsize > MINHISTXSIZE)
        if (xsize > MAXHISTXSIZE)
            winxsize = MAXHISTXSIZE;
        else
            winxsize = xsize+LEEWAY;
    else
        winxsize = MINHISTXSIZE+LEEWAY;

    if (ysize > MINHISTYSIZE)
        if (ysize > MAXHISTYSIZE)
            winysize = MAXHISTYSIZE;
        else
            winysize = ysize+LEEWAY;
    else
        winysize = MINHISTYSIZE+LEEWAY;


	tmp->shell = gr_MakeWindow("XDS Hist",parent,&(tmp->win),
					(XtCallbackProc)gr_CloseHistLevel,
					HISTWIND,label,"Close",(caddr_t)tmp,
					110,10,winxsize+16,winysize+60);

	boxWind = gr_MakeBulletin("XDSbulletin",tmp->win,
					3,winysize+4,winxsize,20);

   gr_MakeButton("XDSbutton",boxWind,"print",
                  (XtCallbackProc) gr_HistPrint,(caddr_t)tmp,
                  2,2,50,14);

   gr_MakeButton("XDSbutton",boxWind,"save",
                  (XtCallbackProc) NULL ,(caddr_t)tmp,
                  62,2,50,14);

	gr_ImageSetCMap(tmp->shell);

	tmp->imageVPort = gr_MakeVPort("XDSvport",tmp->win, NOSCROLL, HP,
			NULL, NULL, 5,(caddr_t)tmp,
			0,0,winxsize,winysize);

	tmp->imageWin	= gr_MakeWorkSpace("XDSworkspace",
						tmp->imageVPort, (XtCallbackProc)gr_HistExpose,
						NULL, NULL,(caddr_t)tmp,
						0,0,xsize,ysize);

	tmp->parent	= tparent;
	tmp->prev	= NULL;
	tmp->next	= header;
	if (header != NULL)
		header->prev = tmp;


	/* init for trace - jng dec 90 */
	/* need to move this to a separate function later */
		tmp->ntraced = 0; /* set to zero, because this is not a trace window */
		tmp->traceX = tmp->traceY = NULL;

	/* null out dialogs and gdata - not in gaussian mode */
	tmp->xDialog = tmp->yDialog = tmp->tDialog = tmp->fDialog =  NULL;
	tmp->gdata = NULL;

	gr_WidgetCursor(tmp->shell,XC_draped_box);
	gr_WidgetCursor(tparent->shell,XC_draped_box);

	return(tmp);
}


/*
 *	Close a Hist Window
* Patched to handle erasing traced line -jng 17 dec 90
* Patched to handle gaussian window - jng 25 may 91
 */
void
gr_CloseHistLevel(w, client_data, call_data)
Widget	w;
caddr_t	client_data;
caddr_t	call_data;
{
	A_HistWind_t	*histWin=(A_HistWind_t *)client_data;
   A_DsplWind_t   *dsplWin=histWin->parent;

	if (histWin != NULL)
	{
		if (histWin->prev != NULL)
			histWin->prev->next = histWin->next;
		else
			histWin->parent->histWin = histWin->next;

		if (histWin->next != NULL)
			histWin->next->prev = histWin->prev;

		histWin->parent->numHistWins--;

		/* here, turn off traced line when window is killed */
		if (histWin->ntraced > 0) {
			displaytracedlines (dsplWin, histWin->traceX, 
										histWin->traceY, histWin->ntraced, FALSE);
			td_Free( histWin->traceX);
			td_Free( histWin->traceY);
			}
		/* here, turn off traced line when window is killed */
			if (histWin->gdata != NULL)    td_Free( histWin->gdata);

		XtDestroyWidget(histWin->shell);
		td_Free((char *)histWin);
	}
}
