#! /bin/csh -f

# 
#  Khoros: $Id: prnmanual.csh,v 1.2 1991/07/15 05:49:18 khoros Exp $
#

#
# $Log: prnmanual.csh,v $
# Revision 1.2  1991/07/15  05:49:18  khoros
# HellPatch1
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: prnmanual.csh                          <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros manual
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>             modified for hp & other non-bsd unix      <<<<
#  >>>>             boxes - kk@hplvis2.hpl.hp.com (6/14/91)   <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# Routine Name:    prnmanual.csh
#
# AUTHORS:      Charlie Gage
#
# DATE:         4/17/91
#
# DESCRIPTION: This shell script will allow a particular Chapter
#              of the khoros manual to be printed.
#
# MODIFICATIONS:   Konstantinos Konstantinides, <kk@hplvis2.hpl.hp.com>
#		   June 14, 1991:  modified prnmanual so that it works
#	           on varied types of machines.  Modified the following
#
#		   1)  STDOUT_FLAG use a full flag "-p" instead of just "p"
#		   2)  Added file extension so that non-postscript formatters
#		       wouldn't with a file.ps (.ps) extension
#		   3)  Added the printer destination name flag PTRNAME_FLAG
#		       since not all unix boxes use -P{printer name}
#		   4)  Added default print command so that the user doesn't
#		       have to change the "lpr" command every time.
#

set path = ( /usr/local/bin /usr/bsd /usr/ucb /usr/bin /bin \
    /usr/etc /usr/local/etc/ /etc/ $KHOROS_HOME/bin . )

onintr cleanup

##### initialize variables #####

set CHAPTER_FLAG = 0
set VOLUME_FLAG = 0
set PRT_FLAG = 0
set PRT_PS_FLAG = 0
set NOPTRNAME = 0
set CHAP8_FLAG = 0
set MAN0_FLG = 0
set MAN1_FLG = 0
set ERR_FLAG = 0
set CMPRES_FLAG = 0
set finished = 0
set TEMPDIR = /tmp

#
# The following are the defaults for UNIX bsd machines running eroff
#
set DEF_PTRCMD   = "lpr"
set PTRNAME_FLAG = "-P"

set DEF_ROFF        = "eroff"
set DEF_STDOUT_FLAG = "-p"
set FILE_EXTEN      = "ps"

#
# The following are the defaults for HP machines running troff (producing pif
# documents)
#
#set DEF_PTRCMD   = "lp -opif"
#set PTRNAME_FLAG = "-d"
#
#set DEF_ROFF        = "troff -t"
#set DEF_STDOUT_FLAG = ""
#set FILE_EXTEN      = "pf"

# Set up environment variables
#----------------------------------------------------
if (! $?KHOROS_HOME) then
   echo ""
   echo "prnmanual: Error, need KHOROS_HOME "
   echo "          environment variable set to proceed."
   echo ""
   exit 0
endif

echo "<<<<<<<<<<<<<<<<<<<<<<<<<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo "prnmanual:"
echo "  An interactive utility for printing the KHOROS manual."
echo ""
echo "  Default reponses are listed in brackets []"
echo ""
echo "<<<<<<<<<<<<<<<<<<<<<<<<<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""
echo ""
echo " Warning:  The print command for your machine has the syntax below."
echo "           If this is not correct, please interrupt this execution to"
echo "           modify the prnmanual script and enter the appropriate "
echo "           line printer settings for your machine."
echo ""
echo "           % $DEF_PTRCMD $PTRNAME_FLAG{printer name} document.$FILE_EXTEN"
echo ""
echo -n "enter <return> to continue... "
set input = $<


# Prompt user for printing of TEST document
# ---------------------------------------
echo ""
echo "A TEST document may be printed to ensure that your"
echo " text formatter and printer are working properly."
echo ""
echo -n "Do you want to print a TEST document (y/n)? [n] "
set test_flg = $<
echo ""
if ($test_flg != 'y') goto contents

echo "Several roff text formatters are available,"
echo " such as eroff, psroff, ditroff, troff, etc. "
echo ""
echo -n "Enter the name of the roff text formatter on your system: [$DEF_ROFF] "
set ROFF = $<
echo ""
if ($ROFF == "" || $ROFF == "$DEF_ROFF") then
   set ROFF = "$DEF_ROFF"
   set STDOUT_FLAG = $DEF_STDOUT_FLAG
else
   echo ""
   echo "Since you did not choose the default text formatter you will need to"
   echo "also supply the flag to format a document to standard output rather"
   echo "than to a default printer.  For instance, the command 'eroff -p test'"
   echo "will format the document 'test' to standard output"
   echo ""
   echo -n "Enter the format standard output flag: [$DEF_STDOUT_FLAG] "
   set STDOUT_FLAG = $<
   echo ""
   if (STDOUT_FLAG == "") then
      STDOUT_FLAG = $DEF_STDOUT_FLAG
   endif
endif

   echo ""
   echo ""
   echo "First, I need two pieces of information from you; "
   echo "   the printer command ( ex. lpr ) and "
   echo "   the printer name ( ex. lw )."
   echo ""
   echo "These two pieces of information will be used to"
   echo " construct a command line such as, lpr -Plw that"
   echo " will direct a document file to the named printer."
   echo ""
   echo "First, give the printer command for your system; "
   echo " This is usually a string such as, lp or lpr "
   echo " Note that the default is [$DEF_PTRCMD]."
   echo ""
   echo -n "Enter printer command: [$DEF_PTRCMD] "

set PTRCMD = $<
if ("$PTRCMD" == "") then
   set PTRCMD = "$DEF_PTRCMD"
endif

   echo ""
   echo ""
   echo "Second, give the printer name for your system; "
   echo " This is also a string such as, lw or laserwriter "
   echo " No default is provided, you must provide a name."
   echo ""
   echo ""
   echo -n "Enter printer name: "

set PTRNAME = $<
if ($PTRNAME == "") then
   set NOPTRNAME = 1
endif

echo ""
echo "Using, text formatter: $ROFF"
if ($NOPTRNAME) then
   echo "      printer command: $PTRCMD"
else
   echo "      printer command: $PTRCMD $PTRNAME_FLAG$PTRNAME"
endif

set TESTFILE = $KHOROS_HOME/manual/test_doc/test.man
set TESTDIR = $TESTFILE:h

if (! -e $TESTFILE) then
   echo ""
   echo "Unable to find $TESTFILE "
   echo "Please ensure that the file $TESTFILE:t exists."
   echo ""
   exit 1
else
   pushd $TESTDIR >& /dev/null
     tbl $TESTFILE:t > test.tbl
     bldmanual -i test.tbl -o test.ms
     $ROFF -ms test.ms $STDOUT_FLAG > test.$FILE_EXTEN
     if ($NOPTRNAME) then
        $PTRCMD test.$FILE_EXTEN
     else
        $PTRCMD $PTRNAME_FLAG$PTRNAME test.$FILE_EXTEN
     endif
     sleep 5
     \rm -f test.tbl test.ms test.$FILE_EXTEN
   popd >& /dev/null
   echo ""
   echo "Check to make sure that the test document "
   echo " was formatted and printed correctly."
   echo "If no errors were found, then rerun prnmanual"
   echo " to print the Khoros manual."
   echo ""
   exit 0
endif


# Print the contents of the Khoros manual
# ---------------------------------------
contents:

echo ""
echo ""
echo "The Khoros manual contains the following volumes and chapters:"
echo ""
echo ""
echo "Volume 0 - Preface and Appendices"
echo ""
echo "      Chapter 0 - Preface"
echo "      Chapter 1 - Appendix A, Glossary"
echo "      Chapter 2 - Appendix B, Changes from Beta release"
echo "      Chapter 3 - Appendix C, Imake Symbols and Variables"
echo ""
echo "Volume 1 - Khoros User's Manual"
echo ""
echo "      Chapter  0 - Title and Contents"
echo "      Chapter  1 - Getting Started"
echo "      Chapter  2 - Cantata"
echo "      Chapter  3 - Xprism2"
echo "      Chapter  4 - Xprism3"
echo "      Chapter  5 - Editimage"
echo "      Chapter  6 - Animate"
echo "      Chapter  7 - Warpimage"
echo "      Chapter  8 - Viewimage"
echo "      Chapter  9 - Concert"
echo "      Chapter 10 - Other Programs"
echo ""
echo -n "Hit <RETURN> to Continue ..."
set cont_flg = $<
echo ""
echo "Volume 2 - Khoros Programmer's Manual"
echo ""
echo "      Chapter  0 - Title and Contents"
echo "      Chapter  1 - Writing Programs / VIFF format"
echo "      Chapter  2 - User Interface Specification"
echo "      Chapter  3 - Preview"
echo "      Chapter  4 - Composer"
echo "      Chapter  5 - Ghost Routines"
echo "      Chapter  6 - Conductor"
echo "      Chapter  7 - Trouble Shooting"
echo "      Chapter  8 - Khoros Libraries"
echo "      Chapter  9 - Configuration Management"
echo "      Chapter 10 - Installation Guide"
echo ""
echo "Volume 3 - Khoros Reference Manual"
echo ""
echo "      Chapter 0 - Title and Contents"
echo "      Chapter 1 - Man(1) Pages"
echo "      Chapter 2 - Man(3) Pages"
echo ""
echo -n "Hit <RETURN> to Continue ..."
set cont_flg = $<
echo ""

# Prompt for printing of a single chapter or an entire volume.
#------------------------------------------------------------
selection:

echo ""
echo ""
echo "You have the option of printing: "
echo ""
echo "	1 - a single chapter"
echo "	2 - an entire volume"
echo ""
echo -n "Enter selection (1 or 2): [1] "
set SELECTION = $<
echo ""
if ( ($SELECTION == '1') || ($SELECTION == "") ) then
   set CHAPTER_FLAG = 1
else if ($SELECTION == '2') then
   echo "Printing an Entire Volume will require"
   echo " that someone attend the printer."
   echo "As many as 1000 pages may be printed."
   echo ""
   echo -n "Continue printing an entire Volume (y/n)? [n] "
   set response = $<
   if ($response == "y") then
       set VOLUME_FLAG = 1
   else
       goto selection
   endif
else
   echo "Invalid Response, please try again..."
   goto selection
endif

echo ""
echo "**********  Select Volume and Chapter  **********"
echo ""

vol_select:
echo ""
echo "Select a Volume: "
echo ""
echo "      Volume 0 - Preface and Appendices"
echo "      Volume 1 - Khoros User's Manual"
echo "      Volume 2 - Khoros Programmer's Manual"
echo "      Volume 3 - Khoros Reference Manual"
echo ""
echo -n "Enter Volume number (0, 1, 2, or 3): "
set VOLUME = $<
echo ""

if ( ($VOLUME > 3) || ($VOLUME == "") ) then
   echo "Invalid Response, you MUST enter a number from 0 to 3 ..."
   goto vol_select
endif

if ($CHAPTER_FLAG) then
   goto vol0
else 
   goto roff_info
endif

# SINGLE CHAPTER: Prompt for specific chapter
#--------------------------------------------
vol0:
if ($VOLUME == '0') then
    echo ""
    echo "Volume 0 - Preface and Appendices"
    echo ""
    echo "      0 - Preface"
    echo "      1 - Glossary (Appendix A)"
    echo "      2 - Changes (Appendix B)"
    echo "      3 - Imake Symbols and Variables (Appendix C)"
    echo ""
    echo -n "Enter Number (0, 1, 2, or 3): "
    set CHAPTER = $<
    echo ""
    if ( ($CHAPTER > 3) || ($CHAPTER == "") ) then
       echo "Invalid Response, you MUST enter a number from 0 to 3 ..."
       goto vol0
    endif
endif

single_chap:
if ($VOLUME == '1') then
    echo ""
    echo "Volume 1 - Khoros User's Manual"
    echo ""
    echo "      Chapter  0 - Title and Contents"
    echo "      Chapter  1 - Getting Started"
    echo "      Chapter  2 - Cantata"
    echo "      Chapter  3 - Xprism2"
    echo "      Chapter  4 - Xprism3"
    echo "      Chapter  5 - Editimage"
    echo "      Chapter  6 - Animate"
    echo "      Chapter  7 - Warpimage"
    echo "      Chapter  8 - Viewimage"
    echo "      Chapter  9 - Concert"
    echo "      Chapter 10 - Other Programs"
    echo ""
    echo -n "Enter Chapter Number (0 - 10): "
    set CHAPTER = $<
    echo ""
    if ( ($CHAPTER > 10) || ($CHAPTER == "") ) then
       echo "Invalid Response, you MUST enter a number from 0 to 10 ..."
       goto single_chap
    endif
else if ($VOLUME == '2') then
vol_2:
    echo ""
    echo "Volume 2 - Khoros Programmer's Manual"
    echo ""
    echo "      Chapter  0 - Title and Contents"
    echo "      Chapter  1 - Writing Programs / VIFF format"
    echo "      Chapter  2 - User Interface Specification"
    echo "      Chapter  3 - Preview"
    echo "      Chapter  4 - Composer"
    echo "      Chapter  5 - Ghost Routines"
    echo "      Chapter  6 - Conductor"
    echo "      Chapter  7 - Trouble Shooting"
    echo "      Chapter  8 - Khoros Libraries"
    echo "      Chapter  9 - Configuration Management"
    echo "      Chapter 10 - Installation Guide"
    echo ""
    echo -n "Enter Chapter Number (0 - 10): "
    set CHAPTER = $<
    echo ""
    if ( ($CHAPTER > 10) || ($CHAPTER == "") ) then
       echo "Invalid Response, you MUST enter a number from 0 to 10 ..."
       goto vol_2
    endif
else if ($VOLUME == '3') then
vol_3:
    echo ""
    echo "Volume 3 - Khoros Reference Manual"
    echo ""
    echo "      Chapter 0 - Title and Contents"
    echo "      Chapter 1 - Man(1) Pages"
    echo "      Chapter 2 - Man(3) Pages"
    echo ""
    echo -n "Enter Chapter number (0, 1, or 2): "
    set CHAPTER = $<
    echo ""
    if ( ($CHAPTER > 2) || ($CHAPTER == "") ) then
       echo "Invalid Response, you must enter a number from 0 to 2 ..."
       goto vol_3
    endif
endif


# Get ROFF information
#---------------------
roff_info:

echo ""
echo "********** Text Formatter and Printer Information **************"
echo ""
echo "Several roff text formatters are available,"
echo " such as eroff, psroff, groff, ditroff, troff, etc. "
echo ""
echo -n "Enter the name of the text formatter on your system: [$DEF_ROFF] "
set ROFF = $<
echo ""
if ($ROFF == "" || $ROFF == "$DEF_ROFF") then
   set ROFF = "$DEF_ROFF"
   set STDOUT_FLAG = $DEF_STDOUT_FLAG
else
   echo ""
   echo "Since you did not choose the default text formatter you will need to"
   echo "also supply the flag to format a document to standard output rather"
   echo "than to a default printer.  For instance, the command 'eroff -p test'"
   echo "will format the document 'test' to standard output"
   echo ""
   echo -n "Enter the format standard output flag: [$DEF_STDOUT_FLAG] "
   set STDOUT_FLAG = $<
   echo ""
   if (STDOUT_FLAG == "") then
      STDOUT_FLAG = $DEF_STDOUT_FLAG
   endif
endif

echo ""
echo "The text formatter will generate a document file"
echo " in the corresponding chapter subdirectory in, "
echo "   $KHOROS_HOME/manual"
echo ""
echo ""
echo -n "Do you want to send the document file to the printer (y/n)? [y] "
set response = $<
if ( ($response == "") || ($response == 'y') ) then
   set PRT_FLAG = 1
   echo ""
   echo ""
   echo "First, I need two pieces of information from you; "
   echo "   the printer command ( ex. lpr ) and "
   echo "   the printer name ( ex. lw )."
   echo ""
   echo "These two pieces of information will be used to"
   echo " construct a command line such as, lpr -Plw that"
   echo " will direct a document file to the named printer."
   echo ""
   echo "First, give the printer command for your system; "
   echo " This is usually a string such as, lp or lpr "
   echo " Note that the default is [$DEF_PTRCMD]."
   echo ""
   echo -n "  Enter printer command: [$DEF_PTRCMD] "
   set PTRCMD = $<

   if ($PTRCMD == "") then
      set PTRCMD = "$DEF_PTRCMD"
   endif

   echo ""
   echo ""
   echo "Second, give the printer name for your system; "
   echo " This is also a string such as, lw or laserwriter "
   echo " No default is provided, you must provide a name."
   echo ""
   echo -n "  Enter printer name: "

   set PTRNAME = $<
   if ($PTRNAME == "") then
      set NOPTRNAME = 1
   endif
endif

echo ""
echo ""
echo "****************** Process the Document **********************"
if ($CHAPTER_FLAG) then
   echo ""
   echo "Volume and Chapter to process is:  Vol $VOLUME  Ch $CHAPTER"
   echo ""
else
   echo ""
   echo "Volume to process is:  Vol $VOLUME"
   echo ""
endif

echo ""
echo "Using, text formatter: $ROFF"
if ($PRT_FLAG) then
   if ($NOPTRNAME) then
      echo "      printer command: $PTRCMD"
   else
      echo "      printer command: $PTRCMD $PTRNAME_FLAG$PTRNAME"
   endif
endif
echo ""
echo ""

echo -n "Do you wish to continue (y/n)? [y] "
set continue_flg = $<
if ( ($continue_flg == 'y') || ($continue_flg == "") ) then
   goto init
else
   goto cleanup
endif

init:
    set LISTFILE = $KHOROS_HOME/manual/Chapters.list

    if (! -e $LISTFILE) then
       echo "the file '$LISTFILE' does not exist"
       exit 0
    else
       source $LISTFILE
    endif

# Initialize loop variables
@ i = 0
set DONE = 0

# Process the specified Volume and Chapter
#-----------------------------------------

#----------------  VOLUME 0  -------------------------
if ( $VOLUME == 0 ) then
 while (! $DONE)
   if ((! $CHAPTER_FLAG) && ($i == 0)) then
       set CHAPTER = $i
       echo ""
       echo "Processing Volume $VOLUME"
       foreach file ($VOL1)
           set VOL_DIR = $file:h
           set VOL_FILE = $file:t
           echo "VOL_DIR = $VOL_DIR"
           echo "VOL_FILE = $VOL_FILE"
       end
       echo ""
   else if ($CHAPTER_FLAG) then
       set DONE = 1
   endif
   switch("$CHAPTER")
      case 0:
         set CHAP_DIR = $V0_CH0[1]:h
         set CHAP_FILE = $V0_CH0[1]:t
         set BASENAME = $V0_CH0[2]
         @ i++
         breaksw
      case 1:
         set CHAP_DIR = $V0_CH1[1]:h
         set CHAP_FILE = $V0_CH1[1]:t
         set BASENAME = $V0_CH1[2]
         @ i++
         breaksw
      case 2:
         set CHAP_DIR = $V0_CH2[1]:h
         set CHAP_FILE = $V0_CH2[1]:t
         set BASENAME = $V0_CH2[2]
         @ i++
         breaksw
      case 3:
         set CHAP_DIR = $V0_CH3[1]:h
         set CHAP_FILE = $V0_CH3[1]:t
         set BASENAME = $V0_CH3[2]
         @ i++
         if (! $CHAPTER_FLAG) then
            set DONE = 1
         endif
         breaksw
      default:
         set CHAP_DIR = "Invalid"
         set CHAP_FILE = "Invalid"
         echo ""
         echo "VOLUME: $VOLUME  CHAPTER: $CHAPTER"
         echo "Volume number and/or Chapter number are invalid."
         echo "Please correct and try again."
         echo""
         exit 1
   endsw

   # Process the selected Chapter from Volume 0
   echo ""
   echo "Processing Volume $VOLUME  Chapter $CHAPTER"
   echo "CHAP_DIR = $CHAP_DIR"
   echo "CHAP_FILE = $CHAP_FILE"
   echo ""
   echo " Document file = $BASENAME.$FILE_EXTEN"
   echo ""
   pushd $CHAP_DIR >& /dev/null
      if ( (-e $BASENAME.ms) || (-e $BASENAME.tbl) ) then
         \rm -f *.ms *.tbl
      endif
      if ( (-e $BASENAME.$FILE_EXTEN) || (-e $BASENAME.$FILE_EXTEN.Z) ) then
         echo ""
         echo "A document file exists for this chapter."
         echo ""
         echo -n "Do you want to print the existing document file (y/n)? [n] "
         set PRT_PS = $<
         echo ""
         if ($PRT_PS == 'y') then
             set PRT_PS_FLAG = 1
             set PRT_FLAG = 1
         else
             \rm -f *.$FILE_EXTEN
         endif
      endif
      echo "Processing document ... "
      if (! $PRT_PS_FLAG) then
          foreach file (`ls *.sec`) >& /dev/null
            if (-e $file) then
                set BASE = `basename $file .sec`
                tbl $file > $BASE.tbl
            endif
          end
        sleep 10
        tbl $CHAP_FILE > $BASENAME.tbl
        bldmanual -i $BASENAME.tbl -o $BASENAME.ms
        $ROFF -ms $BASENAME.ms $STDOUT_FLAG > $BASENAME.$FILE_EXTEN
      endif
      if ($PRT_FLAG) then
         if ($NOPTRNAME) then
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD
            endif 
         else
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
            endif 
         endif
      endif
   popd >& /dev/null

   if ( (! $CHAPTER_FLAG) && (! $DONE) ) then
         set CHAPTER = $i
   else
         set DONE = 1
   endif
 end
endif

#----------------  VOLUME 1  -------------------------
if ( $VOLUME == 1 ) then
 while (! $DONE)
   if ((! $CHAPTER_FLAG) && ($i == 0)) then
       set CHAPTER = $i
       echo ""
       echo "Processing Volume $VOLUME"
       foreach file ($VOL1)
           set VOL_DIR = $file:h
           set VOL_FILE = $file:t
           echo "VOL_DIR = $VOL_DIR"
           echo "VOL_FILE = $VOL_FILE"
       end
       echo ""
   else if ($CHAPTER_FLAG) then
       set DONE = 1
   endif
   switch("$CHAPTER")
      case 0:
         set CHAP_DIR = $VOL1[1]:h
         set CHAP_FILE = $VOL1[1]:t
         set BASENAME = $VOL1[2]
         @ i++
         breaksw
      case 1:
         set CHAP_DIR = $V1_CH1[1]:h
         set CHAP_FILE = $V1_CH1[1]:t
         set BASENAME = $V1_CH1[2]
         @ i++
         breaksw
      case 2:
         set CHAP_DIR = $V1_CH2[1]:h
         set CHAP_FILE = $V1_CH2[1]:t
         set BASENAME = $V1_CH2[2]
         @ i++
         breaksw
      case 3:
         set CHAP_DIR = $V1_CH3[1]:h
         set CHAP_FILE = $V1_CH3[1]:t
         set BASENAME = $V1_CH3[2]
         @ i++
         breaksw
      case 4:
         set CHAP_DIR = $V1_CH4[1]:h
         set CHAP_FILE = $V1_CH4[1]:t
         set BASENAME = $V1_CH4[2]
         @ i++
         breaksw
      case 5:
         set CHAP_DIR = $V1_CH5[1]:h
         set CHAP_FILE = $V1_CH5[1]:t
         set BASENAME = $V1_CH5[2]
         @ i++
         breaksw
      case 6:
         set CHAP_DIR = $V1_CH6[1]:h
         set CHAP_FILE = $V1_CH6[1]:t
         set BASENAME = $V1_CH6[2]
         @ i++
         breaksw
      case 7:
         set CHAP_DIR = $V1_CH7[1]:h
         set CHAP_FILE = $V1_CH7[1]:t
         set BASENAME = $V1_CH7[2]
         @ i++
         breaksw
      case 8:
         set CHAP_DIR = $V1_CH8[1]:h
         set CHAP_FILE = $V1_CH8[1]:t
         set BASENAME = $V1_CH8[2]
         @ i++
         breaksw
      case 9:
         set CHAP_DIR = $V1_CH9[1]:h
         set CHAP_FILE = $V1_CH9[1]:t
         set BASENAME = $V1_CH9[2]
         @ i++
         breaksw
      case 10:
         set CHAP_DIR = $V1_CH10[1]:h
         set CHAP_FILE = $V1_CH10[1]:t
         set BASENAME = $V1_CH10[2]
         @ i++
         if (! $CHAPTER_FLAG) then
            set DONE = 1
         endif
         breaksw
      default:
         set CHAP_DIR = "Invalid"
         set CHAP_FILE = "Invalid"
         echo ""
         echo "VOLUME: $VOLUME  CHAPTER: $CHAPTER"
         echo "Volume number and/or Chapter number are invalid."
         echo "Please correct and try again."
         echo""
         exit 1
   endsw

   # Process the selected Chapter from Volume 1
   echo ""
   echo "Processing Volume $VOLUME  Chapter $CHAPTER"
   echo "CHAP_DIR = $CHAP_DIR"
   echo "CHAP_FILE = $CHAP_FILE"
   echo ""
   echo " Document file = $BASENAME.$FILE_EXTEN"
   echo ""
   pushd $CHAP_DIR >& /dev/null
      if ( (-e $BASENAME.ms) || (-e $BASENAME.tbl) ) then
         \rm -f *.ms *.tbl
      endif
      if (-e $BASENAME.$FILE_EXTEN || -e $BASENAME.$FILE_EXTEN.Z) then
         echo ""
         echo "A document file exists for this chapter."
         echo -n "Do you want to print the existing document file (y/n)? [n] "
         set PRT_PS = $<
         echo ""
         if ($PRT_PS == 'y') then
             set PRT_PS_FLAG = 1
             set PRT_FLAG = 1
         else
             \rm -f *.$FILE_EXTEN
         endif
      endif
      echo "Processing document ... "
      if (! $PRT_PS_FLAG) then
          foreach file (`ls *.sec`) >& /dev/null
            if (-e $file) then
                set BASE = `basename $file .sec`
                tbl $file > $BASE.tbl
            endif
          end
        sleep 10
        tbl $CHAP_FILE > $BASENAME.tbl
        bldmanual -i $BASENAME.tbl -o $BASENAME.ms
        $ROFF -ms $BASENAME.ms $STDOUT_FLAG > $BASENAME.$FILE_EXTEN
      endif
      if ($PRT_FLAG) then
         if ($NOPTRNAME) then
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD
            endif
         else
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
            endif
         endif
      endif
   popd >& /dev/null

   if ( (! $CHAPTER_FLAG) && (! $DONE) ) then
         set CHAPTER = $i
   else
         set DONE = 1
   endif
 end
endif

#-----------------  VOLUME 2 ----------------------
if ($VOLUME == "2") then
 while (! $DONE)
   if ((! $CHAPTER_FLAG) && ($i == 0)) then
       set CHAPTER = $i
   else if ($CHAPTER_FLAG) then
       set DONE = 1
   endif
   switch($CHAPTER)
      case 0:
         set CHAP_DIR = $VOL2[1]:h
         set CHAP_FILE = $VOL2[1]:t
         set BASENAME = $VOL2[2]
         @ i++
         breaksw
      case 1:
         set CHAP_DIR = $V2_CH1[1]:h
         set CHAP_FILE = $V2_CH1[1]:t
         set BASENAME = $V2_CH1[2]
         @ i++
         breaksw
      case 2:
         set CHAP_DIR = $V2_CH2[1]:h
         set CHAP_FILE = $V2_CH2[1]:t
         set BASENAME = $V2_CH2[2]
         @ i++
         breaksw
      case 3:
         set CHAP_DIR = $V2_CH3[1]:h
         set CHAP_FILE = $V2_CH3[1]:t
         set BASENAME = $V2_CH3[2]
         @ i++
         breaksw
      case 4:
         set CHAP_DIR = $V2_CH4[1]:h
         set CHAP_FILE = $V2_CH4[1]:t
         set BASENAME = $V2_CH4[2]
         @ i++
         breaksw
      case 5:
         set CHAP_DIR = $V2_CH5[1]:h
         set CHAP_FILE = $V2_CH5[1]:t
         set BASENAME = $V2_CH5[2]
         @ i++
         breaksw
      case 6:
         set CHAP_DIR = $V2_CH6[1]:h
         set CHAP_FILE = $V2_CH6[1]:t
         set BASENAME = $V2_CH6[2]
         @ i++
         breaksw
      case 7:
         set CHAP_DIR = $V2_CH7[1]:h
         set CHAP_FILE = $V2_CH7[1]:t
         set BASENAME = $V2_CH7[2]
         @ i++
         breaksw
      case 8:
         set CHAP_DIR = $V2_CH8[1]:h
         set CHAP_FILE = $V2_CH8[1]:t
         set BASENAME = $V2_CH8[2]
         set CHAP8_FLAG = 1
         @ i++
         breaksw
      case 9:
         set CHAP_DIR = $V2_CH9[1]:h
         set CHAP_FILE = $V2_CH9[1]:t
         set BASENAME = $V2_CH9[2]
         @ i++
         breaksw
      case 10:
         set CHAP_DIR = $V2_CH10[1]:h
         set CHAP_FILE = $V2_CH10[1]:t
         set BASENAME = $V2_CH10[2]
         @ i++
         if (! $CHAPTER_FLAG) then
            set DONE = 1
         endif
         breaksw
      default:
         set CHAP_DIR = "Invalid"
         set CHAP_FILE = "Invalid"
         echo ""
         echo "VOLUME: $VOLUME  CHAPTER: $CHAPTER"
         echo "Volume number and/or Chapter number are invalid."
         echo "Please correct and try again."
         echo""
         exit 1
   endsw

   # Process the selected Chapter from Volume 2
   echo ""
   echo "Processing Volume $VOLUME  Chapter $CHAPTER"
   echo "CHAP_DIR = $CHAP_DIR"
   echo "CHAP_FILE = $CHAP_FILE"
   echo ""
   echo " Document file = $BASENAME.$FILE_EXTEN"
   echo ""
   pushd $CHAP_DIR >& /dev/null
      if ( (-e $BASENAME.ms) || (-e $BASENAME.tbl) ) then
         \rm -f *.ms *.tbl
      endif
      if (-e $BASENAME.$FILE_EXTEN || -e $BASENAME.$FILE_EXTEN.Z || -e $BASENAME'1'.$FILE_EXTEN || -e $BASENAME'1'.$FILE_EXTEN.Z ) then
         echo ""
         echo "A document file exists for this chapter."
         echo -n "Do you want to print the existing document file (y/n)? [n] "
         set PRT_PS = $<
         echo ""
         if ($PRT_PS == 'y') then
             set PRT_PS_FLAG = 1
             set PRT_FLAG = 1
         else
             \rm -f *.$FILE_EXTEN
         endif
      endif
      echo "Processing document ... "
     if (! $PRT_PS_FLAG) then
         foreach file (`ls *.sec`) >& /dev/null
           if (-e $file) then
               set BASE = `basename $file .sec`
               tbl $file > $BASE.tbl
           endif
         end
       sleep 10
       tbl $CHAP_FILE > $BASENAME.tbl
       bldmanual -i $BASENAME.tbl -o $BASENAME.ms
       if ($CHAP8_FLAG) then
          $ROFF -ms $BASENAME.ms $STDOUT_FLAG -o-140 > $BASENAME'1'.$FILE_EXTEN
          $ROFF -ms $BASENAME.ms $STDOUT_FLAG -o141- > $BASENAME'2'.$FILE_EXTEN
       else
          $ROFF -ms $BASENAME.ms $STDOUT_FLAG > $BASENAME.$FILE_EXTEN
       endif
     endif
     if ($PRT_FLAG && $CHAP8_FLAG) then
        if ($NOPTRNAME) then
            if (-e $BASENAME'1'.$FILE_EXTEN && -e $BASENAME'2'.$FILE_EXTEN) then
               $PTRCMD $BASENAME'1'.$FILE_EXTEN
               $PTRCMD $BASENAME'2'.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME'1'.$FILE_EXTEN.Z && -e $BASENAME'2'.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME'1'.$FILE_EXTEN.Z | $PTRCMD
               uncompress -c $BASENAME'2'.$FILE_EXTEN.Z | $PTRCMD
            endif
        else
            if (-e $BASENAME'1'.$FILE_EXTEN && -e $BASENAME'2'.$FILE_EXTEN) then
               $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME'1'.$FILE_EXTEN
               $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME'2'.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME'1'.$FILE_EXTEN.Z && -e $BASENAME'2'.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME'1'.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
               uncompress -c $BASENAME'2'.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
            endif
        endif
     else if ($PRT_FLAG && ! $CHAP8_FLAG) then
         if ($NOPTRNAME) then
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD
            endif
         else
            if (-e $BASENAME.$FILE_EXTEN) then
               $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME.$FILE_EXTEN
               set CMPRES_FLAG = 1
            else if (-e $BASENAME.$FILE_EXTEN.Z && ! $CMPRES_FLAG) then
               uncompress -c $BASENAME.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
            endif
         endif
     endif
   popd >& /dev/null

   if ( (! $CHAPTER_FLAG) && (! $DONE) ) then
         set CHAPTER = $i
    else
         set DONE = 1
   endif
 end
endif

@ incr = 100
@ parts = 1
@ i = 0

if ($VOLUME == "3") then
 while (! $DONE)
   if ((! $CHAPTER_FLAG) && ($i == 0)) then
       set CHAPTER = $i
   else if ($CHAPTER_FLAG) then
       set DONE = 1
   endif
manpages:
   set ERR_FLAG = 0
   switch($CHAPTER)
      case 0:
         set CHAP_DIR = $VOL3[1]:h
         set CHAP_FILE = $VOL3[1]:t
         set BASENAME = $VOL3[2]
         set MAN0_FLG = 1
         set NUM = x
         @ k = 0
         @ parts = 0
         @ s = 1
         @ f = 100
         @ i++
         breaksw
      case 1:
         set CHAP_DIR = $V3_CH1[1]:h
         set CHAP_FILE = $V3_CH1[1]:t
         set BASENAME = $V3_CH1[2]
         echo ""
         echo "The man1 pages are split into 7 parts."
         echo "Each part contains approximately 100 pages."
         echo "Select which part of the man1 pages to print:"
         echo "  0 - All 7 parts (approx. 700 pages)"
         echo "  1 - Part 1 "
         echo "  2 - Part 2 "
         echo "  3 - Part 3 "
         echo "  4 - Part 4 "
         echo "  5 - Part 5 "
         echo "  6 - Part 6 "
         echo "  7 - Part 7 + Table of Contents"
         echo ""
         echo -n "Enter a number (0 - 7): "
         set NUM = $<
         if ( ($NUM > 7) || ($NUM == "") ) then
            echo "Invalid Response, you MUST enter a number from 0 to 7 ..."
            echo ""
            set ERR_FLAG = 1
         endif
         set MAN1_FLG = 1
         @ i++
         breaksw
      case 2:
         set CHAP_DIR = $V3_CH2[1]:h
         set CHAP_FILE = $V3_CH2[1]:t
         set BASENAME = $V3_CH2[2]
         echo ""
         echo "The man3 pages are split into 6 parts."
         echo "Each part contains approximately 100 pages."
         echo "Select which part of the man3 pages to print:"
         echo "  0 - All 6 parts (approx. 600 pages)"
         echo "  1 - Part 1 "
         echo "  2 - Part 2 "
         echo "  3 - Part 3 "
         echo "  4 - Part 4 "
         echo "  5 - Part 5 "
         echo "  6 - Part 6 + Table of Contents"
         echo ""
         echo -n "Enter a number (0 - 6): "
         set NUM = $<
         if ( ($NUM > 6) || ($NUM == "") ) then
            echo "Invalid Response, you MUST enter a number from 0 to 6 ..."
            echo ""
            set ERR_FLAG = 1
         endif
         @ i++
         if (! $CHAPTER_FLAG) then
            set DONE = 1
         endif
         breaksw
      default:
         set CHAP_DIR = "Invalid"
         set CHAP_FILE = "Invalid"
         echo ""
         echo "VOLUME: $VOLUME  CHAPTER: $CHAPTER"
         echo "Volume number and/or Chapter number are invalid."
         echo "Please correct and try again."
         echo""
   endsw

   if ($ERR_FLAG) then
       set MAN0_FLG = 0
       @ i = 0
       goto manpages
   endif

   # Process the selected Chapter from Volume 3
   if (! $MAN0_FLG) then
     switch ($NUM)
       case 0:
          @ s = 1
          @ f = 100
          @ k = 1
          if ($MAN1_FLG) then
              @ parts = 7
          else
              @ parts = 6
          endif
          breaksw
       case 1:
          @ s = 1
          @ f = 100
          @ k = 1
          @ parts = 1
          echo ""
          echo "Processing Part 1 ..."
          echo ""
          breaksw
       case 2:
          @ s = 101
          @ f = 200
          @ k = 2
          @ parts = 2
          echo ""
          echo "Processing Part 2 ..."
          echo ""
          breaksw
       case 3:
          @ s = 201
          @ f = 300
          @ k = 3
          @ parts = 3
          echo ""
          echo "Processing Part 3 ..."
          echo ""
          breaksw
       case 4:
          @ s = 301
          @ f = 400
          @ k = 4
          @ parts = 4
          echo ""
          echo "Processing Part 4 ..."
          echo ""
          breaksw
       case 5:
          @ s = 401
          @ f = 500
          @ k = 5
          @ parts = 5
          echo ""
          echo "Processing Part 5 ..."
          echo ""
          breaksw
       case 6:
          @ s = 501
          @ f = 600
          @ k = 6
          @ parts = 6
          echo ""
          echo "Processing Part 6 ..."
          echo ""
          breaksw
       case 7:
          if (! $MAN1_FLG) then
             echo "Invalid entry for MAN3 pages, try again."
             goto manpages
          endif
          @ s = 601
          @ f = 700
          @ k = 7
          @ parts = 7
          echo ""
          echo "Processing Part 7 ..."
          echo ""
          breaksw
       default:
          echo ""
          echo "Invalid entry for MAN pages, try again."
          goto manpages
     endsw
   endif

   echo ""
   echo "Processing Volume $VOLUME  Chapter $CHAPTER"
   echo "CHAP_DIR = $CHAP_DIR"
   echo "CHAP_FILE = $CHAP_FILE"
   echo ""
   if ($NUM == 0) then
      echo " Document files for each part are being generated ..."
   else if ($MAN0_FLG) then
      echo " Document file = $BASENAME.$FILE_EXTEN"
   else
      echo " Document file = $BASENAME""_$k.$FILE_EXTEN"
   endif
   echo ""
   pushd $CHAP_DIR >& /dev/null
      if ( (-e $BASENAME.$FILE_EXTEN || -e $BASENAME'_'$k.$FILE_EXTEN || -e $BASENAME'_'$k.$FILE_EXTEN.Z) && ($NUM != 0) ) then
         echo ""
         echo "A document file exists for this chapter."
         echo -n "Do you want to print the existing document file (y/n)? [n] "
         set PRT_PS = $<
         echo ""
         if ($PRT_PS == 'y') then
             set PRT_PS_FLAG = 1
             set PRT_FLAG = 1
         else
             \rm -f $BASENAME'_'$k.$FILE_EXTEN
         endif
      else if ( ($NUM == 0) && (-e $BASENAME'_1'.$FILE_EXTEN || -e $BASENAME'_1'.$FILE_EXTEN.Z) ) then
             \rm -f *.$FILE_EXTEN
      endif
      echo "Processing manpage document ... "
      if (! $PRT_PS_FLAG) then
        if ($MAN0_FLG) then
           \rm -f *.tbl *.ms
           bldmanual -i $BASENAME.man -o $BASENAME.ms
           tbl $BASENAME.ms > $BASENAME.tbl
        else
           \rm -f *.ms
           $KHOROS_HOME/manual/utils/manexpand -i $BASENAME.man -o $BASENAME.ms
        endif
        while (! $finished)
           if ($MAN0_FLG) then
             $ROFF -ms $BASENAME.tbl $STDOUT_FLAG > $BASENAME.$FILE_EXTEN
           else
             $ROFF $KHOROS_HOME/manual/utils/tmac.manpages $BASENAME.ms $STDOUT_FLAG -o$s-$f > $BASENAME'_'$k.$FILE_EXTEN
           endif
           if ($k == $parts) then
              set finished = 1
           endif
           @ k++
           @ s = $s + $incr
           @ f = $f + $incr
        end
      endif
      if ($PRT_FLAG) then
         if ($NOPTRNAME) then
            if ($NUM == 0 && -e $BASENAME'_1'.$FILE_EXTEN) then
               foreach file ( *.$FILE_EXTEN )
                  $PTRCMD $file
               end
            else
               if (-e $BASENAME'_'$parts.$FILE_EXTEN) then
                  $PTRCMD $BASENAME'_'$parts.$FILE_EXTEN
                  set CMPRES_FLAG = 1
               else if (! $CMPRES_FLAG && -e $BASENAME'_'$parts.$FILE_EXTEN.Z) then
                  uncompress -c $BASENAME'_'$parts.$FILE_EXTEN.Z | $PTRCMD
               endif
            endif
         else if (! $NOPTRNAME) then
            if ($NUM == 0 && -e $BASENAME'_1'.$FILE_EXTEN) then
               foreach file ( *.$FILE_EXTEN )
                  $PTRCMD $PTRNAME_FLAG$PTRNAME $file
               end
            else
               if (-e $BASENAME'_'$parts.$FILE_EXTEN) then
                  $PTRCMD $PTRNAME_FLAG$PTRNAME $BASENAME'_'$parts.$FILE_EXTEN
                  set CMPRES_FLAG = 1
               else if (! $CMPRES_FLAG && -e $BASENAME'_'$parts.$FILE_EXTEN.Z) then
                  uncompress -c $BASENAME'_'$parts.$FILE_EXTEN.Z | $PTRCMD $PTRNAME_FLAG$PTRNAME
               endif
            endif
         endif
      endif
   popd >& /dev/null

   if ( (! $CHAPTER_FLAG) && (! $DONE) ) then
         set CHAPTER = $i
   else
         set DONE = 1
   endif
 end
endif

 echo ""
if ($PRT_FLAG) then
 if ($NOPTRNAME) then
    echo "Document sent to Default Printer."
 else
    echo "Document sent to printer ( $PTRNAME )."
 endif
else
 echo "Finished creating Document file."
endif
echo ""

cleanup:

    exit 0
