#include "globals.h"
#include "readbatch.h"
#include "scanargs.h"
#include "hdf.h"

/************************************************************************
*																		*
*	int GenerateBatch(layout, scanData)									*
*																		*
************************************************************************/
int GenerateBatch(layout, scanData)
	LayoutMask *layout;
	ScanData *scanData;
{
	int layoutSize;
	unsigned char *fName;
	static unsigned char format[] = "%s%03u";
	int i,k, count;
	unsigned char *outImage;
	Object *object;
	PixMap outMap;
	
	/* Initialization Section */
	{
		int numDigits, nameLen;

		numDigits = countDigits(scanData->countFirst + 
			(scanData->seqCount-1)*scanData->countInc);
		nameLen = strlen(scanData->outName);
		if((fName = mMalloc(nameLen + numDigits + 1)) == NULL)
			return(-1);
		format[4] = numDigits + '0';

		layoutSize = layout->lx*layout->ly;
		if((outImage = mMalloc(layoutSize)) == NULL)
			return(-1);
	}

	printf("Parameter checking complete.  Beginning output generation.\n");

	outMap.data = outImage;
	outMap.bounds.top = layout->bounds.top; 
	outMap.bounds.left = layout->bounds.left; 
	outMap.bounds.bottom = layout->bounds.bottom; 
	outMap.bounds.right = layout->bounds.right; 
	
	
	for(	i = 0, count = scanData->countFirst;
			i < scanData->seqCount;
			i++, count += scanData->countInc) {
		memcpy(outImage, layout->layout, layoutSize);
		for(k = layout->objectCount-1; k >= 0; k--) {
			object = layout->objectList[k];
			switch(object->kind) {
				case ImageKind: 
					if(DrawImage(object, &outMap, i) != 0)
						return(-1);
					break;
				case CounterKind:
					DrawCounter(object, &outMap, count, layout->styleList);
					break;
			}
		}
		sprintf(fName, format, scanData->outName, count);
		if(WriteImage(fName, outImage, layout->lx, layout->ly, 
				layout->palette, scanData->outMode) < 0)
			return(-1);
		printf("%s\n", fName);
	}
	free(outImage);
	free(fName);
	return(0);
}
