#include "pv.h"


long *
p2i (x,y)
/* DESCRIPTION:  Returns a pointer to an array composed of the coordinates.
*/
	long x, y;
{
	static long p2i[2];

	p2i[0] = x;
	p2i[1] = y;

	return(p2i);
}


float *
p3f (x,y,z)
/* DESCRIPTION:  Returns a pointer to an array composed of the coordinates.
*/
	float x, y, z;
{
	static float p3f[3];

	p3f[0] = x;
	p3f[1] = y;
	p3f[2] = z;

	return(p3f);
}

float
facos2(x, r)
	float x, r;
{
	return facos(x/r);
}


float
fasin2(y, r)
	float y, r;
{
	return (fasin(y/r));
}


void
cart_to_sphere(x, y, z, rho, theta, phi)
	float x, y, z;                  /* Input cartesian coordinates */
	float *rho, *theta, *phi;       /* Output spherical equivalents */
{
	*rho = fhypot(x, fhypot(y, z));
	*theta = fatan2(z, x);
	*phi = facos2(y, *rho);
}


void
sphere_to_cart(rho, theta, phi, x, y, z)
	float rho, theta, phi;          /* Input spherical coordinates */
	float *x, *y, *z;               /* Output cartesian equivalents */
{
	*x = rho * fcos(theta) * fsin(phi);
	*z = rho * fsin(theta) * fsin(phi);
	*y = rho * fcos(phi);
}


void
gprintf(x, y, format, arg)
	long x, y;
	char * format;
	float arg;
/* DESCRIPTION:  gprintf prints a string to the graphics window at
coordinates (x,y).  The "format" and "arg" are used to create the string that
is to be printed, which must be less than 80 characters.
*/
{
	char string[80];
	float cx, cy;

	/* Format the string */
	sprintf(string, format, arg);

	/* Calculate the size of the string and its position */
	cx = x;
	cy = y - (getheight()/2);

	/* Print the string */
	cmov2(cx,cy);
	charstr(string);

	return;
}


int
patmatch(pattern, subject)
        char * pattern;
        char * subject;
/* DESCRIPTION:  Returns TRUE if the subject string matches the pattern and
FALSE otherwise.  At this point, only a wildcard asterisk at the end of string
is supported by this function.
*/
{
        /* As long as there is a complete match between the characters, */
        /* continue the comparison */
        while ((*pattern) && (*subject) &&
               (toupper(*pattern) == toupper(*subject)) ) {
                pattern++;
                subject++;
        }

        /* If the current pattern character is an asterisk, we automatically */
        /* match the rest of the subject string */
        if (*pattern == '*') {
                pattern = subject = "";
        }

        return (toupper(*pattern) == toupper(*subject));
}




void
open_windows(images, windows)
	image_t * images;	
	windat_t ** windows;
/* DESCRIPTION:  open_windows creates windows for all of the "images".  The
window information is added to the windows list.  Also, create a new palette
window.  This release only supports a simgle view window.
*/
{
	image_t * cur_image;

	/* Only create a window for the current image */
	cur_image = images;
	prefsize(NTSC_XSIZ, NTSC_YSIZ);
	create_window(cur_image->fn, images, windows, title_draw,
		      title_event);
	current.window = *windows;
	current.menu_id = (*windows)->win_id;
	current.active_id = (*windows)->win_id;

	/* Create palette window, if there is data for it */
	if (cur_image->color.ds->value != NULL) {
		prefsize(PALETTE_X, PALETTE_Y);
		create_window(cur_image->color.ds->name, images,
			      windows, palette_draw, palette_event);
	}
}


	windat_t *
	create_window(name, image, windows, redraw_fn, event_fn)
		char * name;
		image_t * image;
		windat_t ** windows;
		int (*redraw_fn)();
		int (*event_fn)();
	/* DESCRIPTION:  Creates a new window for the "image", attaches it to
	"event_fn" with it.  Opens a window and stores its ID in the window's
	data structure.  Returns a pointer to the new window, NULL if failure.
	*/
	{
		windat_t * newwin;

		/* ...add a window data structure... */
		newwin = (windat_t *) malloc(sizeof(windat_t));
		newwin->next = *windows;
		*windows = newwin;

		/* ...keep the process in the foreground after windows are */
		/* opened... */
		foreground();

		/* ...create the window... */
		newwin->win_id = winopen(name);
	
		/* ...refer the window to the associated data and set the */
		/* redraw and event handling functions. */
		newwin->data = (char *) image;
		newwin->redraw_fn = redraw_fn;
		newwin->event_fn = event_fn;

		/* Clear the window and initialize its graphics */
		doublebuffer();
		cmode();
		gconfig();
		color(BACKGROUND);
		clear();
		swapbuffers();

		/* Return the address of the new window data structure. */
		return (newwin);
	}


	windat_t *
	get_windat(window, win_id)
		windat_t * window;
		int win_id;
	/* DESCRIPTION:  Returns the window data structure from "windows"
	that is tagged with "win_id".  If the window does not exist, returns
	NULL.
	*/
	{
		/* Search for a matching window data structure */
		while ((window != NULL) && (window->win_id != win_id)) {
			window = window->next;
		}

		return (window);
	}
