'\" t
.\"
.\" %W%	(NCSA)	%G%
.\"
.\" Workaround for SUN man package which defines ]W as Sun Release R.x
.ds ]W NCSA Local Command
.\"
.TH TELTOOL 1 "%G%" "National Center for Supercomputing Applications"
.\"
.SH NAME
teltool \- 
.I SunTools
based telnet program
.\"
.SH SYNOPSIS
.B teltool
[host]
.\"
.SH DESCRIPTION
.I teltool
(NCSA Telnet for the Sun) is a replacement for the standard Sun
Microsystems
.I telnet(1)
program, as well as
.I tektool(1).
Teltool is a window-based telnet with
full VT-102 emulation and Tektronix 4014 graphics emulation.
Hardcopy may be generated in
.I PostScript, HP-GL, 
or Sun raster formats.  You must be running
.I suntools(1)
on a Sun console in order to run
.I teltool.
.\"
.SH MENUS
When 
.I teltool
starts up, it displays a window with a menu bar at the top.  The menus
are 
.I Help, Session, Emulation,
and
.I Options.  
To select an option from one of the menus, press and hold the right mouse
button over the title of the desired menu.  Drag the mouse pointer down
to the desired option and release the button.
.\"
.SH "HELP MENU"
The 
.I Help
menu provides help on the following topics:
.I Version, Session, Emulation, Options, 
and
.I Keyboard.
The help system uses standard 
.I SunView
text subwindows.  When you are done viewing a help file, click
the
.I Done
button to return to the program.
.\"
.\"
.SH "SESSION MENU"
The
.I Session
menu is used to open and close connections, as well as enable/disable
capturing output to a file.  This menu has four options,
.I Open Connection, Close Connection, Capture Session to File,
and
.I End Capture and Close File.
.PP
To open a connection to a remote host, select 
.I Open Connection.
A dialog box will appear and allow you to type in the name of the
desired machine.  If you do not know a hostname for the machine,
or it is not listed in the hosts file, you may specify the Internet
Address instead of the name.  
The default host name will appear in
the dialog box, and you may just hit return or click the button labeled
.B OK
to connect to the default host.  To connect to a different host,
enter the desired host name first.  
If you change your mind, you may
click the button labeled
.B CANCEL
to abort the connection attempt.
The default host name may be changed with the standard 
.I defaultsedit(1)
tool.
.PP
To terminate a session, you should just log out of the remote machine.
If for some reason, this is not possible, you may close the connection
by selecting 
.I Close Connection.
You will be asked if you really want to do this, as it's generally not
a great idea.
.PP
.I teltool
provides a means to log output from a session.  To do so, select
.I Capture Session to File.
You will be asked what to call the file; the default is
.I capture.log
When you no longer wish to capture output, select
.I End Capture and Close File.
Also, if the connection closes for any reason (remote machine crashes,
you log out, etc.) the capture file will automatically be closed.
.\"
.SH "EMULATION MENU"
The
.I Emulation
menu is used during a connection to perform several tasks such
as sending telnet control sequences
or resetting the terminal emulator.  The
.I Emulation
menu contains the following selections:
.I Send `FTP IP Number', Send `FTP 
.I hostname', Send `Are You There?',
.I Send `Abort Output', Send `Interrupt Process', Send `Break',
.I Send `Erase Character', Send `Erase Line', Enable/Disable Line Mode,
and
.I Reset Terminal.
.PP
The FTP sequences provide an easy way for you to generate an FTP
command which is sent to the remote host.  On most hosts,
the remote host will initiate an FTP client program which accesses
the server on your own machine.
Two different flavors of this option are provided.  The first uses
the host name in the FTP command just as you would type in the 
host name from the keyboard.  The second kind of automatic FTP
command, `FTP IP number', uses the full IP address of your host 
instead of your host name to save the remote host the trouble of 
looking up your IP address. 
.PP
Several special telnet character sequences
may be sent from this menu.
.I `Are You There?'
verifies that the connection is still active.
.I `Abort Output'
causes the remote host to stop transmitting,
but leaves the process running.
.I `Interrupt Process'
will cause the remote machine to terminate
the running process.  On most systems,
.I `Break'
will have a similar effect.  Also, you can send
.I `Erase Character'
and 
.I `Erase Line'
sequences to cause those actions to take place.  Finally,
you can reset the current state of the VT-102 terminal
emulator to a default setting, should it be confused by
a random control sequence such as "switch to graphics character
set."
.\"
.SH "OPTIONS MENU"
The
.I Options
menu allows you to change several settings used by
.I teltool.
This menu contains the following selections:
.I Activate/Deactivate Special Characters, Change Special Characters,
.I Change Default PostScript Device,
.I Change Default HP-GL Device,
.I Change Default TEK Output File,
and
.I Change Default BitMap Device.
.PP
Special Keyboard Characters provides a way to use the keyboard
for several control sequences, rather than having to pull down
the
.I Emulation
menu.  This feature is off by default because it may confuse users
who aren't aware of it.  When you enable the special characters,
you are causing selected keys to be interpreted by
.I teltool,
rather than transmitted to the remote host.  The functions you
can map are:
.I Erase Char, Erase Line, Interrupt Process, 
.I Abort Output, Break,
and
.I Scroll-Lock.
.PP
Special Characters can only be mapped to control keys.  The mapping
can be changed by selecting
.I Change Special Characters.
A panel will pop up with a list of functions and the control
characters to which they are bound.  You can
enter a new control character sequence by clicking on the old one
with the left mouse button, and pressing the
.B DELETE (L10)
key.  Then type the new sequence in as ^ followed by the letter
you want (? for 
.I DELETE.)
Click
.B OK
to store this change, or
.B CANCEL
to abort.
.I N.B.
this change only lasts for the duration of the program, to change the
default permanently, use
.I defaultsedit(1).
.PP
The default devices for hardcopy output can also be changed in a
similar fashion.  When you select an option, a dialog box appears
with the current default.  The current value can be deleted in
the same manner as the Special Character sequence above.  A device/file
name which starts with a | is interpreted as a command to be executed
on the data stream.  Again, these changes are not saved when you exit
the program; to make them permanent, use
.I defaultsedit(1).
.\"
.SH "VT-102 WINDOW FEATURES"
The VT-102 window is completely resizable.  Two menu options are provided
to allow you to quickly resize to common sizes, 80x24, and 132x24.
Also, VT-102 windows have horizontal and vertical scroll bars which
can be used to scroll back to look at previous text, or scroll sideways
if you resize the window to be smaller than 80 columns.  Since
.I SunView
scroll bars are somewhat non-intuitive, 
.I teltool's
scroll bars have some improvements over standard way of doing things.  The
following table describes what to do to get a particular scroll
operation:
.PP
.TS
center tab (/) box;
cfB s s s .
Scroll Bar Motions
_
.T&
lfB | lfB | lfB .
Button/Scroll Bar/Page Button
_
.T&
l  | l  | l .
Left/Backwards (Left)/Backwards (Left)
Right/Forward (Right)/Forward (Right)
Middle/Absolute Positioning/Page Forward (Right)
Shift-Left/Page Backwards (Left)/No Effect
Shift-Right/Page Forwards (Right)/No Effect
Shift-Middle/No Effect/Page Backwards (Left)
.TE
.TE
.PP
.\"
.SH "VT-102 EMULATION"
Currently, 
.I teltool
supports almost all features of a VT-102.  Notable
exceptions are: blinking characters, double-height characters,
and double-width characters.
.SH KEYPAD
As much as possible, 
.I teltool
uses a standard VT-102 keypad mapping.  Unfortunately, the Sun
keyboard does not have a suitable layout to allow complete
emulation.  The following is a map of the keypad layout:
.PP
.TS
center tab (/) box;
cfB s s s .
VT-102 Keypad Emulation
_
.T&
cfB | cfB | cfB .
7/8/9
_
4/5/6
_
1/Up/3
_
Left/2/Right
_
0/Down/Enter
.TE
.PP
Some keys are not on the keypad because there is no room for them.
These are mapped to the top row of function keys:
.PP
.TS
center tab (/) box;
cfB s s s s s s s s .
VT-102 Function Keys
_
.T&
cfB | cfB | cfB | cfB | cfB | cfB | cfB | cfB | cfB | cfB .
Sun Key/F1/F2/F3/F4/F5/F6/F7/F8/F9
_
VT-100 Key/PF1/PF2/PF3/PF4/\-/,/./Unused/Scroll-Lock
.TE
.PP
.\"
.SH TEKTRONIX 
If your current window is the VT-102 window,
.I teltool
creates a Tektronix window upon receipt of the standard Tektronix
screen-clear sequence <ESC><CTRL>-L.
Once you are in a Tektronix window, <ESC><CTRL>-L clears the 
screen just like a real Tektronix terminal.
To create another Tektronix window, move back to the VT-102 window
and generate an <ESC><CTRL>-L.  You may have up to five Tektronix
windows active at any time.
.PP
While viewing a Tektronix image, you may zoom the image in one of two
ways.  You can use the slider control at the top of the window, or you
may draw a rubber-band box around the portion of the image you wish to
view.  To do this, hold down the left mouse button at one corner of the
area you want to see, and then move the mouse until the box covers the
desired viewing area.  Then, release the left button, and the window
will zoom.
.PP
Once the window has been zoomed, the scroll bars will become active.
You may use them to pan to other areas of the picture which are not
currently visible.  The Tektronix scroll bars work identically to
the VT-102 scroll bars.
.PP
To view the full image once you have zoomed, either press the right
button over the image and select the
.I UnZoom
item from the menu, or click the slider control at the extreme right
edge.
The menu also allows you to generate hardcopy output.  You may get
hardcopy in three ways:
.I PostScript,
.I HP-GL,
and Sun raster format (a 1 pixel deep bitmap image of the screen).
The hardcopy can be written to a file, or piped to any UNIX command.
See the information on the 
.I Options
menu above.  Also, you can save a dump of the tektronix image in
a file for later output.
Finally, the menu contains an item which acts as the
.I PAGE
key on a Tektronix terminal and clears the window.
.PP
Tektronix windows are completely resizable.
.I teltool
will automatically compute a new aspect ratio based on the window size.
This means that there may be unused white space on the right edge or
at the bottom of the window.  The slider control and the scroll bars
will adjust to the new size of the window.
.PP
When Tektronix windows are created, they are normally 640 by 500 pixels.
However, if your
Sun's monitor is not 1152x900, one of these values may change slightly
in order to maintain the correct aspect ratio.  This is handled automatically
by asking the system frame buffer for it's dimensions, and dynamically
computing the aspect ratio.
.\"
.SH "KEYBOARD TRACKING"
.I teltool
automatically tracks the mouse to whatever Tektronix window you move
it to.  However, to avoid splitting an image between two windows,
you must type a key in the new window to make it active.  This is 
true of the VT-102 window as well.
.\"
.SH DEFAULTS
.I teltool
is fairly well integrated with the SunView Defaults Package.  There
is a separate category in
.I defaultsedit(1)
for 
.I teltool.
Among the things you can change are default output devices for
various types of hardcopy, the default host to connect to,
and special character mapping.
.\"
.SH AUTHORS
Teltool was written by Steve Alexander 
at the National Center for Supercomputing
Applications, University of Illinois, Urbana-Champaign.  
The Telnet protocol parser was written
by Tim Krauskopf, VT-102 emulation by Gaige Paulsen, and Tektronix
graphics by Aaron Contorer.  All of these pieces were glued together
with SunView by Steve Alexander.
.\"
.SH BUGS
There's no way to abort a pending connection attempt; you must wait
for it to time out.
.br
For no clearly explainable reason, Tektronix doesn't work on a Sun-3/110.
.br
The Menu Bar does not shrink indefinitely if you make the window smaller.
.br
SunView could have better scroll bars.
.br
Splitting the view on a help window and then clicking the 'Done' button
will crash the notifier.
.\"
.SH FILES
.I ~/.defaults
.br
.I ./capture.log
.br
.I ./tek.out
.\"
.SH "SEE ALSO"
.I Windows and Window Based Tools: Beginner's
.I Guide,
.br
.I Using the Network: Beginner's Guide,
.br
.I The SunView System Programmer's Guide
.br
.I telnet(1), tektool(1), suntools(1), defaultsedit(1), lpr(1),
.I rastrepl(1), rasfilter8to1(1)
.\"
.SH TRADEMARKS
HP-GL is a registered trademark of Hewlett-Packard Co.
.br
PostScript is a registered trademark of Adobe Systems, Inc.
.br
SUN is a registered trademark of Sun Microsystems, Inc.
.br
SunTools is a registered trademark of Sun Microsystems, Inc.
.br
TEKTRONIX is a registered trademark of Tektronix, Inc.
.br
VT is a registered trademark of the Digital Equipment Corporation
