
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int ch_seqfmt()
/*
/* DESCRIPTION:
/*    Changes the format of 24-bit 'seq' format image files.  Any
/*    type of conversion between pixel-interlace, scan-line interlace,
/*    and image-plane interlace is possible.
/*
/* USAGE:
/*    error_ret = ch_seqfmt(in_fmt,out_fmt,inbuf,outbuf,xsiz,ysiz)
/*
/* ARGUMENTS:
/*    int            in_fmt   (in)  : input format where
/*                                  :    1 - pixel interlace
/*                                  :    2 - scan-line interlace
/*                                  :    3 - image-plane interlace
/*    int            out_fmt  (in)  : output format (see in_fmt above)
/*    unsigned char  *inbuf   (in)  : input image
/*    unsigned char  *outbuf  (out) : output image
/*    int            xsiz     (in)  : X dimension of image
/*    int            ysiz     (in)  : Y dimension of image
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : illegal value for in_fmt
/*    2 : illegal value for out_fmt
/*
/* COMMENTS:
/*    Format '3' corresponds to the current definition of the 24-bit
/*    'seq' format specification.
/*
/* EXAMPLE:
/* SEE ALSO:
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : November 30, 1988
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

int ch_seqfmt(in_fmt,out_fmt,inbuf,outbuf,xsiz,ysiz)
int in_fmt,out_fmt;
unsigned char inbuf[],outbuf[];
int xsiz,ysiz;
{

	register int i;
	int j;
	int err_ret;
	int num_bytes,xsiz3,xysiz;
	unsigned char *r1,*g1,*b1,*r2,*g2,*b2;
	unsigned char *buf_ptr;

	err_ret = 0;

	if ((in_fmt != 1) && (in_fmt != 2) && (in_fmt != 3)){
		err_ret = 1;
		goto error;
	}

	if ((out_fmt != 1) && (out_fmt != 2) && (out_fmt != 3)){
		err_ret = 2;
		goto error;
	}

	xsiz3 = xsiz * 3;
	xysiz = xsiz * ysiz;
	num_bytes = xsiz3 * ysiz * sizeof(char);

	if (in_fmt == out_fmt){
		b1 = &inbuf[0];
		b2 = &outbuf[0];
		i = num_bytes;
		do{
			i--;
			*b2++ = *b1++;
		}while(i);
	}
	else if ((in_fmt == 1) && (out_fmt == 2)){
		buf_ptr = &outbuf[0];
		r1 = &inbuf[0];
		g1 = &inbuf[1];
		b1 = &inbuf[2];
		for(j=0; j<ysiz; j++){
			r2 = buf_ptr;
			g2 = r2 + xsiz;
			b2 = g2 + xsiz;
			buf_ptr = buf_ptr + xsiz3;
			i = xsiz;
			do{
				i--;
				*r2++ = *r1++;
				*g2++ = *g1++;
				*b2++ = *b1++;
				r1 = b1;
				g1 = r1 + 1;
				b1 = g1 + 1;
			}while(i);
		}
	}
	else if ((in_fmt == 1) && (out_fmt == 3)){
		r1 = &inbuf[0];
		g1 = &inbuf[1];
		b1 = &inbuf[2];
		r2 = &outbuf[0];
		g2 = r2 + xysiz;
		b2 = g2 + xysiz;
		i = xysiz;
		do{
			i--;
			*r2++ = *r1++;
			*g2++ = *g1++;
			*b2++ = *b1++;
			r1 = b1;
			g1 = r1 + 1;
			b1 = g1 + 1;
		}while(i);
	}
	else if ((in_fmt == 2) && (out_fmt == 1)){
		buf_ptr = &inbuf[0];
		r2 = &outbuf[0];
		g2 = &outbuf[1];
		b2 = &outbuf[2];
		for (j=0; j<ysiz; j++){
			r1 = buf_ptr;
			g1 = r1 + xsiz;
			b1 = g1 + xsiz;
			buf_ptr = buf_ptr + xsiz3;
			i = xsiz;
			do{
				i--;
				*r2++ = *r1++;
				*g2++ = *g1++;
				*b2++ = *b1++;
				r2 = b2;
				g2 = r2 + 1;
				b2 = g2 + 1;
			}while(i);
		}
	}
	else if ((in_fmt == 2) && (out_fmt == 3)){
		buf_ptr = &inbuf[0];
		r2 = &outbuf[0];
		g2 = r2 + xysiz;
		b2 = g2 + xysiz;
		for (j=0; j<ysiz; j++){
			r1 = buf_ptr;
			g1 = r1 + xsiz;
			b1 = g1 + xsiz;
			buf_ptr = buf_ptr + xsiz3;
			i = xsiz;
			do{
				i--;
				*r2++ = *r1++;
				*g2++ = *g1++;
				*b2++ = *b1++;
			}while(i);
		}
	}
	else if ((in_fmt == 3) && (out_fmt == 1)){
		r1 = &inbuf[0];
		g1 = r1 + xysiz;
		b1 = g1 + xysiz;
		r2 = &outbuf[0];
		g2 = &outbuf[1];
		b2 = &outbuf[2];
		i = xysiz;
		do{
			i--;
			*r2++ = *r1++;
			*g2++ = *g1++;
			*b2++ = *b1++;
			r2 = b2;
			g2 = r2 + 1;
			b2 = g2 + 1;
		}while(i);
	}
	else if ((in_fmt == 3) && (out_fmt == 2)){
		buf_ptr = &outbuf[0];
		r1 = &inbuf[0];
		g1 = r1 + xysiz;
		b1 = g1 + xysiz;
		for (j=0; j<ysiz; j++){
			r2 = buf_ptr;
			g2 = r2 + xsiz;
			b2 = g2 + xsiz;
			buf_ptr = buf_ptr + xsiz3;
			i = xsiz;
			do{
				i--;
				*r2++ = *r1++;
				*g2++ = *g1++;
				*b2++ = *b1++;
			}while(i);
		}
	}

error:
#if RTE_PRERR
	err_msg("ch_seqfmt",err_ret);
#endif
	return(err_ret);
}
