!****************************************************************************
!* descrip.mms for drawp3d
!* Author Joel Welling
!* Copyright 1991, Pittsburgh Supercomputing Center, Carnegie Mellon University
!*
!* Permission use, copy, and modify this software and its documentation
!* without fee for personal use or use within your organization is hereby
!* granted, provided that the above copyright notice is preserved in all
!* copies and that that copyright and this permission notice appear in
!* supporting documentation.  Permission to redistribute this software to
!* other organizations or individuals is not granted;  that must be
!* negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
!* University make any representations about the suitability of this
!* software for any purpose.  It is provided "as is" without express or
!* implied warranty.
!*****************************************************************************/

SRC= ge_error.c,indent.c,c_vlist_mthd.c,f_vlist_mthd.c,m_vlist_mthd.c,-
	p3d_ren_mthd.c,null_mthd.c,camera_mthd.c,transform.c,attribute.c,-
	gob_mthd.c,sphere_mthd.c,cyl_mthd.c,torus_mthd.c,text_mthd.c,-
	light_mthd.c,ambient_mthd.c,pmark_mthd.c,pline_mthd.c,pgon_mthd.c,-
	tri_mthd.c,bezier_mthd.c,mesh_mthd.c,cmap_mthd.c,chash_mthd.c,-
	p3dgen.c,std_cmap.c,color.c,drawp3d_fi.c,drawp3d_ci.c,-
	boundbox.c,isosurf.c,cube_cases.c,axis.c,vector.c,zsurface.c,-
	material.c,dirichlet.c,gauss.c,rand_zsurf.c,rand_isosurf.c,-
	symbol.c,ihash_mthd.c,assist_attr.c,default_attr.c,assist_prim.c,-
	assist_spln.c,assist_text.c,assist.c,dum_ren_mthd.c

PAINT_SRC= pnt_ren_mthd.c,painter.c,painter_clip.c,painter_util.c,-
	paintr_trans.c

OBJ= ge_error.obj,indent.obj,c_vlist_mthd.obj,f_vlist_mthd.obj,-
	m_vlist_mthd.obj,p3d_ren_mthd.obj,null_mthd.obj,camera_mthd.obj,-
	transform.obj,attribute.obj,gob_mthd.obj,sphere_mthd.obj,-
	cyl_mthd.obj,torus_mthd.obj,text_mthd.obj,light_mthd.obj,-
	ambient_mthd.obj,pmark_mthd.obj,pline_mthd.obj,pgon_mthd.obj,-
	tri_mthd.obj,bezier_mthd.obj,mesh_mthd.obj,cmap_mthd.obj,-
	chash_mthd.obj,p3dgen.obj,std_cmap.obj,color.obj,drawp3d_fi.obj,-
	drawp3d_ci.obj,boundbox.obj,isosurf.obj,axis.obj,vector.obj,-
	zsurface.obj,material.obj,dirichlet.obj,gauss.obj,rand_zsurf.obj,-
	rand_isosurf.obj,symbol.obj,ihash_mthd.obj,assist_attr.obj,-
	default_attr.obj,assist_prim.obj,assist_spln.obj,assist_text.obj,-
	assist.obj

PAINT_OBJ= pnt_ren_mthd.obj,painter.obj,painter_clip.obj,painter_util.obj,-
	paintr_trans.obj

EXECUTABLES= c_tester.exe f_tester.exe obj_tester.exe

INSTALLABLES= drawp3d.olb drawp3dx.olb

all : $(INSTALLABLES) $(EXECUTABLES)
	write sys$output "All done making DrawP3D."

drawp3d.olb : $(OBJ) dum_ren_mthd.obj
	$(LIBR)/create drawp3d.olb $(OBJ),dum_ren_mthd.obj

drawp3dx.olb : $(OBJ) $(PAINT_OBJ) dum_gl_mthd.obj
	$(LIBR)/create drawp3dx.olb $(OBJ),$(PAINT_OBJ),dum_gl_mthd.obj

dum_gl_mthd.obj : dum_ren_mthd.c
	$(CC)/nolist/object=dum_gl_mthd.obj/define=INCL_PAINTER dum_ren_mthd.c

c_tester.exe : c_tester.obj drawp3d.olb cc.opt
	$(LINK) c_tester.obj,drawp3d.olb/lib,cc/opt

f_tester.exe : f_tester.obj drawp3d.olb cc.opt
	$(LINK) f_tester.obj,drawp3d.olb/lib,cc/opt

obj_tester.exe : obj_tester.obj drawp3d.olb cc.opt
	$(LINK) obj_tester.obj,drawp3d.olb/lib,cc/opt

clean :
	if f$search("*.obj") .nes. "" then del *.obj;*

clobber : clean
	if f$search("*.exe") .nes. "" then del *.exe;*
	if f$search("*.olb") .nes. "" then del *.olb;*

f_tester.obj : f_tester.f
	$(FORT) f_tester.f

ge_error.obj : ge_error.c
indent.obj : indent.c
indent.obj : ge_error.h
indent.obj : indent.h
c_vlist_mthd.obj : c_vlist_mthd.c
c_vlist_mthd.obj : p3dgen.h
c_vlist_mthd.obj : pgen_objects.h
c_vlist_mthd.obj : indent.h
c_vlist_mthd.obj : ge_error.h
f_vlist_mthd.obj : f_vlist_mthd.c
f_vlist_mthd.obj : p3dgen.h
f_vlist_mthd.obj : pgen_objects.h
f_vlist_mthd.obj : indent.h
f_vlist_mthd.obj : ge_error.h
m_vlist_mthd.obj : m_vlist_mthd.c
m_vlist_mthd.obj : p3dgen.h
m_vlist_mthd.obj : pgen_objects.h
m_vlist_mthd.obj : indent.h
m_vlist_mthd.obj : ge_error.h
p3d_ren_mthd.obj : p3d_ren_mthd.c
p3d_ren_mthd.obj : p3dgen.h
p3d_ren_mthd.obj : pgen_objects.h
p3d_ren_mthd.obj : indent.h
p3d_ren_mthd.obj : ge_error.h
p3d_ren_mthd.obj : p3d_preamble.h
null_mthd.obj : null_mthd.c
null_mthd.obj : p3dgen.h
null_mthd.obj : pgen_objects.h
null_mthd.obj : ge_error.h
camera_mthd.obj : camera_mthd.c
camera_mthd.obj : p3dgen.h
camera_mthd.obj : pgen_objects.h
camera_mthd.obj : indent.h
camera_mthd.obj : ge_error.h
transform.obj : transform.c
transform.obj : p3dgen.h
transform.obj : pgen_objects.h
transform.obj : ge_error.h
transform.obj : indent.h
attribute.obj : attribute.c
attribute.obj : p3dgen.h
attribute.obj : pgen_objects.h
attribute.obj : indent.h
attribute.obj : ge_error.h
gob_mthd.obj : gob_mthd.c
gob_mthd.obj : p3dgen.h
gob_mthd.obj : pgen_objects.h
gob_mthd.obj : indent.h
gob_mthd.obj : ge_error.h
sphere_mthd.obj : sphere_mthd.c
sphere_mthd.obj : p3dgen.h
sphere_mthd.obj : pgen_objects.h
sphere_mthd.obj : indent.h
sphere_mthd.obj : ge_error.h
cyl_mthd.obj : cyl_mthd.c
cyl_mthd.obj : p3dgen.h
cyl_mthd.obj : pgen_objects.h
cyl_mthd.obj : indent.h
cyl_mthd.obj : ge_error.h
torus_mthd.obj : torus_mthd.c
torus_mthd.obj : p3dgen.h
torus_mthd.obj : pgen_objects.h
torus_mthd.obj : indent.h
torus_mthd.obj : ge_error.h
text_mthd.obj : text_mthd.c
text_mthd.obj : p3dgen.h
text_mthd.obj : pgen_objects.h
text_mthd.obj : indent.h
text_mthd.obj : ge_error.h
light_mthd.obj : light_mthd.c
light_mthd.obj : p3dgen.h
light_mthd.obj : pgen_objects.h
light_mthd.obj : indent.h
light_mthd.obj : ge_error.h
ambient_mthd.obj : ambient_mthd.c
ambient_mthd.obj : p3dgen.h
ambient_mthd.obj : pgen_objects.h
ambient_mthd.obj : indent.h
ambient_mthd.obj : ge_error.h
pmark_mthd.obj : pmark_mthd.c
pmark_mthd.obj : p3dgen.h
pmark_mthd.obj : pgen_objects.h
pmark_mthd.obj : indent.h
pmark_mthd.obj : ge_error.h
pline_mthd.obj : pline_mthd.c
pline_mthd.obj : p3dgen.h
pline_mthd.obj : pgen_objects.h
pline_mthd.obj : indent.h
pline_mthd.obj : ge_error.h
pgon_mthd.obj : pgon_mthd.c
pgon_mthd.obj : p3dgen.h
pgon_mthd.obj : pgen_objects.h
pgon_mthd.obj : indent.h
pgon_mthd.obj : ge_error.h
tri_mthd.obj : tri_mthd.c
tri_mthd.obj : p3dgen.h
tri_mthd.obj : pgen_objects.h
tri_mthd.obj : indent.h
tri_mthd.obj : ge_error.h
bezier_mthd.obj : bezier_mthd.c
bezier_mthd.obj : p3dgen.h
bezier_mthd.obj : pgen_objects.h
bezier_mthd.obj : indent.h
bezier_mthd.obj : ge_error.h
mesh_mthd.obj : mesh_mthd.c
mesh_mthd.obj : p3dgen.h
mesh_mthd.obj : pgen_objects.h
mesh_mthd.obj : indent.h
mesh_mthd.obj : ge_error.h
cmap_mthd.obj : cmap_mthd.c
cmap_mthd.obj : p3dgen.h
cmap_mthd.obj : pgen_objects.h
cmap_mthd.obj : indent.h
cmap_mthd.obj : ge_error.h
chash_mthd.obj : chash_mthd.c
chash_mthd.obj : p3dgen.h
chash_mthd.obj : pgen_objects.h
chash_mthd.obj : ge_error.h
p3dgen.obj : p3dgen.c
p3dgen.obj : p3dgen.h
p3dgen.obj : pgen_objects.h
p3dgen.obj : std_cmap.h
p3dgen.obj : ge_error.h
p3dgen.obj : indent.h
std_cmap.obj : std_cmap.c
std_cmap.obj : std_cmap.h
color.obj : color.c
color.obj : p3dgen.h
color.obj : pgen_objects.h
color.obj : ge_error.h
color.obj : indent.h
drawp3d_fi.obj : drawp3d_fi.c
drawp3d_fi.obj : ge_error.h
drawp3d_fi.obj : p3dgen.h
drawp3d_fi.obj : ge_error.h
drawp3d_ci.obj : drawp3d_ci.c
drawp3d_ci.obj : p3dgen.h
drawp3d_ci.obj : drawp3d.h
drawp3d_ci.obj : ge_error.h
c_tester.obj : c_tester.c
c_tester.obj : p3dgen.h
c_tester.obj : drawp3d.h
c_tester.obj : ge_error.h
boundbox.obj : p3dgen.h pgen_objects.h ge_error.h
isosurf.obj : p3dgen.h ge_error.h cube_cases.c
axis.obj : p3dgen.h pgen_objects.h
vector.obj : p3dgen.h pgen_objects.h
zsurface.obj : p3dgen.h pgen_objects.h ge_error.h
material.obj : p3dgen.h pgen_objects.h ge_error.h indent.h
dirichlet.obj : p3dgen.h ge_error.h dirichlet.h
gauss.obj : p3dgen.h pgen_objects.h dirichlet.h ge_error.h
rand_zsurf.obj : p3dgen.h pgen_objects.h dirichlet.h ge_error.h
rand_isosurf.obj : p3dgen.h pgen_objects.h ge_error.h dirichlet.h
symbol.obj : p3dgen.h pgen_objects.h indent.h ge_error.h
ihash_mthd.obj : p3dgen.h pgen_objects.h ge_error.h
assist_attr.obj : p3dgen.h pgen_objects.h ge_error.h assist.h
default_attr.obj : p3dgen.h pgen_objects.h ge_error.h
assist_prim.obj : p3dgen.h pgen_objects.h ge_error.h assist.h 
assist_prim.obj : sphere.h cylinder.h
assist_spln.obj : p3dgen.h pgen_objects.h ge_error.h assist.h
assist_text.obj : ge_error.h p3dgen.h pgen_objects.h assist.h hershey.h
assist.obj : p3dgen.h pgen_objects.h ge_error.h assist.h
pnt_ren_mthd.obj : p3dgen.h pgen_objects.h ge_error.h
pnt_ren_mthd.obj : assist.h paintr_strct.h painter.h
painter.obj : ge_error.h p3dgen.h pgen_objects.h
painter.obj : assist.h paintr_strct.h painter.h
painter_clip.obj : ge_error.h p3dgen.h pgen_objects.h
painter_clip.obj : assist.h paintr_strct.h painter.h
painter_util.obj : ge_error.h p3dgen.h
painter_util.obj : pgen_objects.h assist.h paintr_strct.h painter.h
paintr_trans.obj : ge_error.h p3dgen.h pgen_objects.h
paintr_trans.obj : assist.h paintr_strct.h painter.h
dum_ren_mthd.obj : p3dgen.h pgen_objects.h ge_error.h
