.TH MARCHP3D L "9/10/92" "release 2.0"
.SH NAME
Marchp3d takes a 3-dimensional array and a value and finds an isosurface
at that value.  It then emits a p3d metafile (optionally in color) containing
the information for that isosurface.
.SH SYNOPSIS
.nf
.B "marchp3d -x xdim -y ydim -z zdim -v value [max step] [-n iterations]" 
.B "[-c c_scheme clr_data min max] [-i] [-b]
.B "[-l x|y|z|-x|-y|-z] [-t x_com y_com z_com angle]
.B "[-r renderer] [-d device] [-s datastr] array_data"
.fi

.SH DESCRIPTION
Marchp3d takes a 3 dimensional array of floats, and using the marching 
cubes algorithm finds an isosurface at a given value.  It can 
optionally take another array of the same size, with scalars representing 
colors of the corresponding vertices of the original array, and a color 
table which is used to convert these scalars into colors.  It then 
produces a P3D metafile containing a description of the resulting 
(colored) isosurface.  

P3D is the model description language used by the Pittsburgh Supercomputing 
Center.  Calling marchp3d causes a P3D metafile to be written to standard 
output.  This output can be used to create 3D images of the model.

Xdim, ydim, and zdim are the x-, y-, and z- dimensions of the data array,
respectively.  They must be integers.  The array should have a total of
xdim*ydim*zdim entries.  

Value is the value at which an isosurface is desired.  This can be an integer
or float.  This value need not appear at any given vertex of the array, 
the marching cubes algorithm will interpolate to find where it would be 
located between given points. If max and step are specified, the program
will output a p3d file containing isosurfaces at values from the value
specified to max, in increments of step.

Iterations specifies how many datasets should be read. The default is one,
specifing that one dataset should be read from the input file[s].

-i tells the program to orient polygons the clockwise, producing the "inside"
surface.

-b tells the program to draw a bounding box around the dataset.

-l specifies the axis to look at the model from; x, y, and z for the positive
x, y, and z axes, optionally prefaced by a '-' to indicate the negative
side of the axis.

-t specifies turning information, in the form of the x, y, and z components
of the angle to rotate about, and the angle by which to rotate the model
each frame.  This switch and the option of changing the isovalue are not
exclusive, and combining them can produce interesting results.

Renderer, device, and datastr specify which renderer to use. The default is to
activate the p3d renderer, sending the output to stdout. Any valid drawp3d
renderer, however, may be used (currently, painter, and gl on Silicon Graphics
workstations). Device and datastr are renderer-specific; see the description
of p3d for details.  For example, selecting the p3d renderer with a 
file name in the device field will cause P3D output to be written to that
file.  Selecting the painter renderer with the device xws will cause the
model to be drawn directly in an X window on the current X display.
Selecting the painter renderer and the device cgmb, and specifying
a file name for datastr will cause a CGM metafile version of the output
to be written to the file.

Array_data is the main data file, containing xdim*ydim*zdim floats or integers.
If a single minus (-) is given rather than a filename, this data will be taken
from the standard input.

The following is a brief description of the color option:
.TP 8 
.B \-c c_scheme clr_data min max	   

C_scheme is the number of the color scheme to use, or optionally
the name of a user-created table of numbers and associated
color values, to be used with the scalar table.  Color scheme numbers
are small non-negative integers, and correspond to the standard color
schemes of the DrawP3D graphics library.

Clr_data is a 3 dimensional array of numbers, one for each entry of
the data array.  These numbers are associated with colors using the
color table, and thus each node of the data array, and by
interpolation every vertex of the isosurface, is associated with a
color. If a single minus (-) is given rather than a filename, this
data will be taken from the standard input (if both the color data and
the array data are coming from the same file (such as the standard
input), the color data will be read first, followed by the array data).

Min and max are two numbers (floating point or integer)
separated by a space, representing the lower and
upper bounds for entries in the clr_data file, which will map onto the  
lowest and highest entries in the color table.  All
scalars in the clr_data file must be within this
range, and will be matched to an appropriate 
color table value by interpolation.	  

.SH FILE DESCRIPTIONS

The
.I array_data
file will contain a list of numbers (floating point or integer)
separated by spaces.  These numbers will represent a three dimensional
array of the size specified by xdim, ydim, and zdim.  The numbers will
be understood according to the C language convention, that is, the list
wil be turned into a 3-dimensional array by looping on x, then y, then
z, so the z coordinate changes fastest.  These scalars
can be thought of as the values of some function in 3-space, with their 
position in the array corresponding to the position in 3-space.

The
.I clr_data
file will also contain a list of numbers (floating point or integer)
separated by spaces.  It will be of the same format, and the same size
as the array_data file.  Scalars in the clr_data file can be thought of
as values of some other function in 3-space, and will be translated
into color.  Thus, one can study the values of the second function
for a given value (the value of the isosurface) of the first function.
These color for a given point is found by interpolating into the clr_data 
scalars and mapping the resulting value into the color table.  This 
mapping is done using the min and max values supplied by the user.  
The min will map to the first (nonempty) entry in the color table, the max 
will map to the last.  The position of a given number between the min and 
max determines the position of the associated color between the lowest and
highest color of the color table, and that color is assigned to the 
point.

The 
.I c_table 
file (if used instead of a default color scheme) will
contain information from which a color table will be made.  Each line
in the c_table file consists of an integer followed by three or four
floating point numbers between 0.0 and 1.0.  The integer represents
the index of the color table, and the following three or four floats
represent the color to be associated with that index.  The first float
specifies the degree of red coloring, the second specifies green, the
third specifies blue, and the last (optional) specifies opacity (the
default value is 1.0).  All indices must lie between 0 and 255
inclusive, since they will be used to index an array of size 256.
Although they need not be inputted in order, they must result in a
continous list between the lowest and highest index.  Gaps between
entries in the color table will lead to errors when the color
interpolation is done.

.SH COPYRIGHT
Copyright 1989, 1992 Pittsburgh Supercomputing Center, Carnegie Mellon
University
.nf
.B "Author Julie Roskies"
.B "Modified 1992 Robert Earhart"
.fi
