/****************************************************************************
 * mi.h
 * Author Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/*
This module provides entry points and structs for the 'mouse user interface'.
*/

/* Struct to hold mouse position information */
typedef struct mouse_pos_struct { int x, y, maxx, maxy; } MousePosition;

/* Structs to hold view information */
struct CoordTriple { float x, y, z; };
typedef struct view_struct {
  struct CoordTriple from, at, up;
  float fovea;
  float hither,yon;
  struct view_struct *next; /* for use in making flybys */
} Viewpoint;

/* Mouse UI module entry points */
extern void miu_approach_model();
extern void miu_translate_model();
extern void miu_rotate_model();
extern void miu_redraw();
extern void miu_load();
extern char *miu_filename();
extern void miu_done();
extern void miu_exit();
extern void miu_prompt_redraw();
extern void miu_set_viewpoint();
extern void miu_toggle_trace();
extern double miu_viewing_distance();
extern Viewpoint *miu_viewpoint();

/* Entry points for particular user interface toolkits */
extern void mil_setup();
extern void mil_shutdown();
extern void mil_event();
extern void mil_update();

