/****************************************************************************
 * assist.h
 * Author Joel Welling
 * Copyright 1990, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* These entry points are provided by the assist module */

extern void ast_sphere();
extern void ast_cylinder();
extern void ast_torus();
extern void ast_prim_reset();
extern void ast_text();
extern void ast_text_reset();
extern void ast_bezier();
extern void ast_spln_reset();
extern void ast_polygon_normals();
extern void ast_mesh_normals();
extern void ast_triangle_normals();
extern void ast_push_attributes();
extern void ast_pop_attributes();
extern int ast_bool_attribute();
extern Color ast_color_attribute();
extern Material ast_material_attribute();
extern float ast_float_attribute();
extern int ast_int_attribute();
extern char *ast_string_attribute();
extern void ast_ctb_init();
extern int ast_ctb_bestindex();
extern void ast_vlist_ave_color();
extern void ast_init_matrix();
extern float *ast_clear_matrix();
extern float *ast_load_matrix();
extern float *ast_push_matrix();
extern float *ast_pop_matrix();
extern float *ast_get_matrix();
