#!/bin/sh 
#ident "%W%"	%G%
#
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.

VERSION="5.0 Beta"
echo
echo "Installing Portable Dore' Version $VERSION"
echo
tape=
echo "Enter non-rewind tape device: [/dev/nrtape]"
read tape
if [ -z "$tape" ]; then
    tape=/dev/nrtape
fi
if [ -d dore ]; then
    echo "directory 'dore' exsits, do you wish to install here? [y/n]"
    read ans
    while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
        echo "Please answer y or n"
	read ans
    done
    if [ $ans = "n" ]; then
        echo "Installation aborted"
	mt -f $tape rewind > /dev/null 2>&1
	if [ $? -ne 0 ]; then
	    mt -t $tape rewind
	fi
	exit 1
    fi

    echo
    echo "The Portable Dore' Version $VERSION release has"
    echo "a significantly different directory structure"
    echo "than previous releases.  It is not recommended"
    echo "to install Portable Dore' Version $VERSION in"
    echo "a directory containing a previous release."
    echo
    echo "Are you SURE you want to proceed ? [y/n]"
    read ans
    while [ -z "$ans" -o \( "$ans" != "y" -a "$ans" != "n" \) ]; do
        echo "Please answer y or n"
	read ans
    done

    if [ $ans = "n" ]; then
	echo "Installation aborted"
	mt -f $tape rewind > /dev/null 2>&1
	if [ $? -ne 0 ]; then
	    mt -t $tape rewind
	fi
	exit 1
    fi
fi

echo 
echo "Extracting all files ..."
cpio -iadvmcB <$tape
echo
echo "Rewinding tape ..."
mt -f $tape rewind > /dev/null 2>&1 
if [ $? -ne 0 ]; then
    mt -t $tape rewind
fi
echo
echo "Done"

