 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "spectrum.h"

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>		Routines To Change Map Columns Displayed
 >>>>
 >>>>			change_band_map()
 >>>>			change_band_function()
 >>>>			update_band_col()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name:  change_band_map
*
*       Purpose:  When the user clicks on the 'Red', 'Green'
*		  and 'Blue' buttons, changes the map associated
*		  with the Red, Green or Blue band (1-to-1)
*
*         Input:  form - pointer to the form tree 
*		  blank_index - index of Blank (-b) line in UIS
*				following Pane Action (-a) line
*		  colorband - one of SpcRed, SpcGreen, SpcBlue
*
*        Output:  changes map associated w/ Red, Green or Blue
*
*     Called By:  run_files()
*
*    Written By:  Danielle Argiro
*
********************************************************/

change_band_map(form, blank_index, func_index, colorband)
xvf_form *form;
int blank_index;
int func_index;
int colorband;
{
	float *new_col;
	int   col_num;
	char **choices, temp[MaxLength];
        XawListReturnStruct *list_return;

	char *promptR = "Select map column to use as RED band",
	     *promptG = "Select map column to use as GREEN band",
	     *promptB = "Select map column to use as BLUE band",
	     *label   = "  ", *prompt;

	/* appropriate prompt depending on color band */
	if (colorband == SpcRed)
	   prompt = promptR;
        else if (colorband == SpcGreen)
	   prompt = promptG;
        else if (colorband == SpcBlue)
	   prompt = promptB;

	/* create the list of choices of Map Columns */
	choices = create_mapcol_list();

	/* put up the list widget to get new column */
	list_return = xvf_run_list_wait(choices, spc_map_colnum, 2, 
		      prompt, label, 0, false);
	if (list_return == NULL) return;
	col_num = list_return->list_index;

	sprintf(temp, "M%d", col_num);
	new_col = copy_column(spc_map[col_num]);
	if (colorband == SpcRed)
	{
	    current_red_func = xvf_strcpy(temp);
	    if (current_red_col != NULL) free(current_red_col);
	    current_red_col = new_col;
	}
        else if (colorband == SpcGreen)
	{
            current_green_func = xvf_strcpy(temp);
	    if (current_green_col != NULL) free(current_green_col);
	    current_green_col = new_col;

	}
        else if (colorband == SpcBlue)
	{
	    if (current_blue_col != NULL) free(current_blue_col);
	    current_blue_col = new_col;
            current_blue_func = xvf_strcpy(temp);
	}

	/* update info in map column */
	update_band_col(colorband);

	/* update image displayed */
	xvd_update_xcolors(xvdisplay);

	/* update info displayed on form with Blank selection */
	sprintf(temp, "M%d", col_num);
	xvf_change_input(form, blank_index, xvf_title_chng, temp, 30);
	sprintf(temp, "M%d", col_num);
	xvf_change_input(form, func_index, xvf_stringval_chng, temp, 30);
	

	free(choices);
	free(list_return);
}


/********************************************************
*
*  Routine Name:  change_band_function
*
*       Purpose:  When the user clicks on the 'Apply' button,
*		  changes the the Red, Green or Blue band
*		  according to the function specified for that band.
*
*         Input:  func_string - desired function provided by user
*		  colorband   - one of SpcRed, SpcGreen, SpcBlue
*
*        Output:  changes map associated w/ Red, Green or Blue
*
*     Called By:  run_files()
*
*    Written By:  Danielle Argiro
*
********************************************************/

change_band_function(func_string, colorband)
char *func_string;
int colorband;
{
	int  i, var_num;
	float  float_val;
	float  *new_column, *copy_column(); 
	char temp[MaxLength], *init_string;
	char **var_list, *function;

	/* parse variables MX out of function string */ 
	var_list =  variable_scan(func_string, &var_num);
	if (var_list == NULL) return;

	/* create syntactically correct function definition 
	   from function defintion pass to vexpr parser */
	if (colorband == SpcRed)
	   init_string = "Red(";
	else if (colorband == SpcGreen)
	   init_string = "Green(";
	else if (colorband == SpcBlue)
	   init_string = "Blue(";
	function = create_function_def(func_string, init_string,
			 	       var_list, var_num);

	/* send function definition to vexpr parser */
	if (!(xve_eval_float(SpcId, function, &float_val, temp)))
        {
		xvf_error_wait(temp, "change_band_function", NULL);
		return;
	}

	/* perform the specified function on the map columns specified */
	new_column = perform_map_function(colorband, var_list, var_num);

	if (colorband == SpcRed)
	{
	    current_red_func = xvf_strcpy(func_string);
	    current_red_col  = new_column;
	}
	else if (colorband == SpcGreen)
	{
	    current_green_func = xvf_strcpy(func_string);
	    current_green_col  = new_column;
	}
	else if (colorband == SpcBlue)
	{
	    current_blue_func = xvf_strcpy(func_string);
	    current_blue_col  = new_column;
	}
	update_band_col(colorband);

	free(var_list);
	free(function);
}

/********************************************************
*
*  Routine Name:  update_band_col
*
*       Purpose:  updates the map column stored as a 
*		  the red, green, or blue band.
*
*         Input:  colorband   - one of SpcRed, SpcGreen, SpcBlue
*        Output:  changes map associated w/ Red, Green or Blue
*    Written By:  Danielle Argiro
*
********************************************************/

update_band_col(colorband)
int colorband;
{
	int i;

	if (colorband == SpcRed)
	{
	   if (norm_red_col != NULL) free(norm_red_col);
	   norm_red_col = copy_column(current_red_col);
           norm_data(norm_red_col, SpcRed);

	   for (i = 0; i < spc_map_rownum; i++)
             xvdisplay->xcolors[i].red = ((unsigned short)
                                           norm_red_col[i]) << 8;

	   if (spc_norm_type == SpcNormGlobal)
	   {
		norm_data(norm_green_col, SpcGreen);
	        transfer_mapcol_to_xcolors(norm_green_col, SpcGreen);

		norm_data(norm_blue_col, SpcBlue);
	        transfer_mapcol_to_xcolors(norm_blue_col, SpcBlue);
	   }
	}
	else if (colorband == SpcGreen)
	{
	   if (norm_green_col != NULL) free(norm_green_col);
	   norm_green_col = copy_column(current_green_col);
           norm_data(norm_green_col, SpcGreen);

	   for (i = 0; i < spc_map_rownum; i++)
             xvdisplay->xcolors[i].green = ((unsigned short)
                                             norm_green_col[i]) << 8;

	   if (spc_norm_type == SpcNormGlobal)
	   {
		norm_data(norm_red_col, SpcRed);
	        transfer_mapcol_to_xcolors(norm_red_col, SpcRed);

		norm_data(norm_blue_col, SpcBlue);
	        transfer_mapcol_to_xcolors(norm_blue_col, SpcBlue);
	   }
	}
	else if (colorband == SpcBlue)
	{
	   if (norm_blue_col != NULL) free(norm_blue_col);
   	   norm_blue_col = copy_column(current_blue_col);
           norm_data(norm_blue_col, SpcBlue);

	   for (i = 0; i < spc_map_rownum; i++)
             xvdisplay->xcolors[i].blue = ((unsigned short)
                                            norm_blue_col[i]) << 8;

	   if (spc_norm_type == SpcNormGlobal)
	   {
		norm_data(norm_red_col, SpcRed);
	        transfer_mapcol_to_xcolors(norm_red_col, SpcRed);

		norm_data(norm_blue_col, SpcGreen);
	        transfer_mapcol_to_xcolors(norm_blue_col, SpcGreen);
	   }
	}
}
