#include "Optimizer.hpp"

namespace SoftWire
{
	bool Optimizer::dropUnmodified = true;
	bool Optimizer::spillUnrelocated = false;

	Optimizer::Optimizer()
	{
	}

	Optimizer::~Optimizer()
	{
	}

	const Optimizer::AllocationTable Optimizer::getAllocationState()
	{
		AllocationTable state;

	//	if(spillUnrelocated)
		{
			RegisterAllocator::spillAll();
			return state;
		}

		for(int i = 0; i < 8; i++)
		{
			state.ERX[i] = ERX[i];
			state.MM[i] = MM[i];
			state.XMM[i] = XMM[i];
		}

		return state;
	}

	void Optimizer::spillAll(const AllocationTable &state)
	{
	//	if(spillUnrelocated)
		{
			RegisterAllocator::spillAll();
			return;
		}

	/*	for(int i = 0; i < 8; i++)
		{
			if(ERX[i].reference != state.ERX[i].reference)
			{
				spill32(i);
			}

			if(MM[i].reference != state.MM[i].reference)
			{
				spill64(i);
			}

			if(XMM[i].reference != state.XMM[i].reference)
			{
				spill128(i);
			}
		}	*/
	}

	void Optimizer::restoreForward(const AllocationTable &state)
	{
	//	if(spillUnrelocated)
		{
			RegisterAllocator::spillAll();
			return;
		}

		spillAll(state);
	}

	void Optimizer::restoreBackward(const AllocationTable &state)
	{
	//	if(spillUnrelocated)
		{
			RegisterAllocator::spillAll();
			return;
		}

	/*	for(int i = 0; i < 8; i++)
		{
			if(ERX[i].reference != state.ERX[i].reference)
			{
				spill32(i);
				assign32(i, state.ERX[i].reference, true, state.ERX[i].partial);
			}

			if(MM[i].reference != state.MM[i].reference)
			{
				spill64(i);
				assign64(i, state.MM[i].reference, true);
			}

			if(XMM[i].reference != state.XMM[i].reference)
			{
				spill128(i);
				assign128(i, state.XMM[i].reference, true, state.XMM[i].partial != 0);
			}
		}	*/
	}

	void Optimizer::enableDropUnmodified()
	{
		dropUnmodified = true;
	}

	void Optimizer::disableDropUnmodified()
	{
		dropUnmodified = false;
	}

	void Optimizer::enableSpillUnrelocated()
	{
		spillUnrelocated = true;
	}

	void Optimizer::disableSpillUnrelocated()
	{
		spillUnrelocated = false;
	}

	Encoding *Optimizer::x86(int instructionID, const Operand &firstOperand, const Operand &secondOperand, const Operand &thirdOperand)
	{
		return RegisterAllocator::x86(instructionID, firstOperand, secondOperand, thirdOperand);
	}
}