// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// Name:        labels.h
//
// Purpose:     interface to various labels
//
// Created:      6 Sep 94   Michael Pichler
//
// Changed:     11 Oct 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_labels_h
#define harmony_widgets_labels_h


#include <InterViews/label.h>
class Color;
class Font;
class WidgetKit;
class Brush;  // for UnderlinedLabel



//<class>
//
// Name: UnderlinedLabel
//
// Purpose: label with parts of it underlined
//
//</class>


class UnderlinedLabel: public Label
{
  public:
    UnderlinedLabel (                   // constructor
      const char* str,                  //   string
      const Font* font,                 //   font (non nil)
      const Color* color,               //   foreground color (non nil)
      int from,                         //   index of first and
      int to                            //   index behind last char to underline
    );                                  //     (or -1: up to end)
    virtual ~UnderlinedLabel ();

    // most often used underlined labels (use kit.font and foreground):

    static UnderlinedLabel* udlLabel (  // label, underlined as a whole
      WidgetKit& kit,                   //   kit
      const char* str,                  //   string
      const char* style = 0,            //   style name
      const char* alias = 0             //   style alias
    );

    static UnderlinedLabel* hotLabel (  // label with first char underlined
      WidgetKit& kit,                   //   kit
      const char* str,                  //   string
      const char* style = 0,            //   style name
      const char* alias = 0,            //   style alias
      int no = 0,                       //   which character (0 = first one)
      int num = 1                       //   no. of chars to underline
    );

    virtual void draw (Canvas*, const Allocation&) const;

  private:
    int from_;
    int to_;
    Brush* brush_;

};  // UnderlinedLabel


#endif
