// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name:       ocolor.h
//
// Purpose:    Interface to observable colour,
//             which manages RGB/HLS components and provides
//             scrollbars and field editors for colour change
//
// Created:     6 Apr 93    Michael Pichler
//
// Modified:   18 May 94    Michael Pichler
//
//
//</file>



#ifndef harmony_widgets_ocolor_h
#define harmony_widgets_ocolor_h



#include <InterViews/observe.h>
class Adjustable;
class OCAdjustable;
class FieldBrowser;

// OColor - observable color
// observable/obersver-protocol for other oberservers (like color viewer)
// communication with adjusters done directly

class OColor: public Observable
{
  public:
    OColor (float r = 0.0, float g = 0.0, float b = 0.0);
    ~OColor ();

    enum { R, G, B, H, L, S, _num,
           HEXRGB = _num                // HEXRGB field editor
         };

    Adjustable* getadj (int);           // get an adjustable
    float getval (int);                 // get a color component (RGBHLS)

    FieldBrowser* getfed (int);         // get a field editor

    void setrgb (float, float, float);  // set a colour (RGB)

    void changed (int);                 // a color component has changed

    static int ftoiRGBHLS (float fval, int index)
    { return (int) (fval * cfactor_ [index] + 0.5);  // round (i * 255) etc.
    }
    static float itofRGBHLS (int ival, int index)
    { return (float) ival / cfactor_ [index];  // i / 255 etc.
    }
    static int hextoi (char hexdigit);
    static const char* rgbtohex (float r, float g, float b);

  private:
    static const char* itoa3 (int ival);

    OCAdjustable* adj_ [_num];
    FieldBrowser* fed_ [_num+1];  // in fact field editors

    static const float cfactor_ [_num];  // coversion factors for RGBHLS
};



#endif
