// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        progressb.h
//
// Purpose:     interface to progress indicator base class
//
// Created:      8 Nov 94   Michael Pichler
//
// Changed:     11 Apr 95   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_progressb_h
#define harmony_widgets_progressb_h


//<class>
//
// Class ProgressBase - base class for progress indicator, independent of UI
//
// For feedback set and get have to be implemented, stop flag must be
// delivered (UI dependent, e.g. class Progress)
//
// Running processes should set/increase the progress and can ask for stop,
// meaning they should stop themselves
//
//</class>


class ProgressBase
{
  public:
    ProgressBase()  { }                 // constructor

    void reset()  { set (0.0); }        // reset progress bar

    virtual void set(                   // set progress
      float,                            //   to a fraction of 1.0
      int /*repair*/ = 1                //   default: immediate repair
    ) { }

    void increase(                      // increase progress
      float p,                          //   by a fraction of 1.0
      int repair = 1                    //   default: immediate repair
    ) { set (get () + p, repair); }

    virtual float get() const           // get current progess
    { return 0.0; }

    virtual int stop() const            // get stop flag
    { return 0; }

};  // ProgressBase



#endif
