// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//

#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMux.h"
#include "CpuMuxP.h"
#include "Thread.h"
#include "ReserveByException.h"
#include "SpinLock.h"
#include <math.h>

#define NOTREACHED  0

int CpuMux::Muxs;
SpinLock CpuMux::MuxsLock;

CpuMux * CpuMux::ThisCpu;
SpinLock CpuMux::CerrLock;

bool CpuMux::Debug;

//
//	This can not be private, or we wont see all the action
//

static int StopCpuMux;

int CpuMuxDebugFlag = 0;

//
// Used by some external C programs (like malloc) for consistency checks
//
static int DefaultIdPtr;
int *AwesimeCpuId = &DefaultIdPtr;

CpuMux::CpuMux(bool debug) : systemContext(0, 0)
{
    pNameTemplate = "CpuMux";
    currentThread = 0;
    enabled = 0;
    iYam = 0;
    AwesimeCpuId = &iYam;
    pid = 0;
    CpuMuxDebugFlag = debug;
    ThisCpu = this;
    terminated = &StopCpuMux;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
}

CpuMux::~CpuMux()
{
    // empty
}

void
CpuMux::debug(int newdebug)
{
    CpuMuxDebugFlag = newdebug;
}

int
CpuMux::debug()
{
    return(CpuMuxDebugFlag);
}

void
CpuMux::terminateAll_()
{
    *terminated = 1;
}


void
CpuMux::fireItUp(int, unsigned)
{
    assert( NOTREACHED );
}

void
CpuMux::warmThePot(int)
{
    assert( NOTREACHED );
}

void
CpuMux::coolItDown()
{
    assert( NOTREACHED );
}

void
CpuMux::add_(Thread*)
{
    assert( NOTREACHED );
}

void
CpuMux::addReserve_()
{
    // empty
}

void
CpuMux::addUnlocked_(Thread *thread)
{
    add(thread);
}

void
CpuMux::addRelease_()
{
    // empty
}

//
// This is the job dispatcher.
//

void
CpuMux::stirItAround()
{
    assert( NOTREACHED );
}

void
CpuMux::reschedule_(Thread* to)
{
    currentThread -> cpuAffinity = -1;
    //
    // prefer no one
    //
    rescheduleException.switchTo( to );
    raise( &rescheduleException ); 
}


#if 0
void
CpuMux::raise(ExceptionClass *by)
{
    assert( by != 0 );
    ThisCpu -> raisedBy = by;
    ThisCpu -> currentThread -> pContext.switchContext( &(ThisCpu -> systemContext) );
}

void
CpuMux::reserveByException( ReserveByException *sem )
{
    ThisCpu -> reserveException.reserve(sem);
    ThisCpu -> raise( &(ThisCpu -> reserveException) );
}

void
CpuMux::threadTerminateException( Thread *killMe )
{
    ThisCpu -> terminateException.terminate( killMe );
    ThisCpu -> raise( &(ThisCpu -> terminateException) );
}

#endif
