#ifdef __GNUG__
#  pragma implementation
#endif

#include "Thread.h"
#include "PQScheduler.h"
#include "stream.h"
#include "assert.h"

PQScheduler::PQScheduler()
    : pq()
{
    // empty
}

void
PQScheduler::add(Thread *t)
{
    pq.enq( t );
}

Thread *
PQScheduler::remove()
{
    ThreadPtr t = 0;
    if ( ! pq.empty() ) {
	t = pq.deq();
    }
    return( t );
}

bool PQScheduler::isEmpty()
{
    if ( pq.empty() ) {
	return TRUE;
    } else {
	return FALSE;
    }
}

unsigned int PQScheduler::size()
{
    return(pq.length());
}

Pix PQScheduler::first()
{
    return( pq.first() );
}

void PQScheduler::next(Pix& i)
{
    pq.next(i);
}

Thread*&
PQScheduler::operator()(Pix i)
{
    return(pq(i));
}
