/* 
Copyright (C) 1990 by Dirk Grunwald (grunwald@foobar.colorado.edu)

This file is part of Awesime.

Awesime is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY.  No author or distributor accepts responsibility to
anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Awesime, but only under the conditions described in the Gnu General
Public License.  A copy of this license is supposed to have been given
to you along with Awesime so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.

*/
// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//

#ifdef __GNUG__
#  pragma implementation
#endif

#include "SlidingStatistic.h"
#include <math.h>

SlidingStatistic::SlidingStatistic( int s )
{
    sample = new double [ s ]; 
    maxSamples = s;
    head = 0;
    cached = 0;
}

SlidingStatistic::~SlidingStatistic()
{
    if (maxSamples > 0) {
	delete sample;
    }
}

void
SlidingStatistic::operator+=(double value)
{
    if ( head >= maxSamples ) {
	head = 0;
    }
    if ( n >= maxSamples ) {
	//
	//	Remove the oldest value
	//
	n--;
	x -= sample[head];
	x2 -= (sample[head] * sample[head]);
    }

    sample[ head ] = value;
    head++;

    n ++;
    x += value;
    x2 += (value * value);

    cached = 0;
}

void
SlidingStatistic::reset()
{
    Statistic::reset();
    cached = 0;
    head = 0;
}

void
SlidingStatistic::cacheValues()
{
    minValue = MAXFLOAT;
    maxValue = -MAXFLOAT;
    for ( int i = 0; i < n; i++ ) {
	minValue = (minValue < sample[i]) ? minValue : sample[i];
	maxValue = (maxValue < sample[i]) ? sample[i] : maxValue;
    }
    cached = 1;
}

double
SlidingStatistic::min()
{
    if (!cached) {
	cacheValues();
    }
    return( minValue );
}

double
SlidingStatistic::max()
{
    if (!cached) {
	cacheValues();
    }
    return( maxValue );
}
