// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _ThreadPtrSplayPQ_h
#ifdef __GNUG__
#pragma interface
#endif
#define _ThreadPtrSplayPQ_h 1

#include "ThreadPtr.PQ.h"
#include "ThreadPtr.SplayNode.h"

class ThreadPtrSplayPQ : public ThreadPtrPQ
{
protected:
  ThreadPtrSplayNode*   root;

  ThreadPtrSplayNode*   leftmost();
  ThreadPtrSplayNode*   rightmost();
  ThreadPtrSplayNode*   pred(ThreadPtrSplayNode* t);
  ThreadPtrSplayNode*   succ(ThreadPtrSplayNode* t);
  void            _kill(ThreadPtrSplayNode* t);
  ThreadPtrSplayNode*   _copy(ThreadPtrSplayNode* t);

public:
                  ThreadPtrSplayPQ();
                  ThreadPtrSplayPQ(ThreadPtrSplayPQ& a);
  virtual       ~ThreadPtrSplayPQ();

  Pix           enq(ThreadPtr  item);
  ThreadPtr           deq(); 

  ThreadPtr&          front();
  void          del_front();

  int           contains(ThreadPtr  item);

  void          clear(); 

  Pix           first(); 
  Pix           last(); 
  void          next(Pix& i);
  void          prev(Pix& i);
  ThreadPtr&          operator () (Pix i);
  void          del(Pix i);
  Pix           seek(ThreadPtr  item);

  int           OK();                    // rep invariant
};


inline ThreadPtrSplayPQ::~ThreadPtrSplayPQ()
{
  _kill(root);
}

inline ThreadPtrSplayPQ::ThreadPtrSplayPQ()
{
  root = 0;
  count = 0;
}

inline ThreadPtrSplayPQ::ThreadPtrSplayPQ(ThreadPtrSplayPQ& b)
{
  count = b.count;
  root = _copy(b.root);
}

inline Pix ThreadPtrSplayPQ::first()
{
  return Pix(leftmost());
}

inline Pix ThreadPtrSplayPQ::last()
{
  return Pix(rightmost());
}

inline void ThreadPtrSplayPQ::next(Pix& i)
{
  if (i != 0) i = Pix(succ((ThreadPtrSplayNode*)i));
}

inline void ThreadPtrSplayPQ::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((ThreadPtrSplayNode*)i));
}

inline ThreadPtr& ThreadPtrSplayPQ::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((ThreadPtrSplayNode*)i)->item;
}

inline void ThreadPtrSplayPQ::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int ThreadPtrSplayPQ::contains(ThreadPtr  key)
{
  return seek(key) != 0;
}

#endif
