// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef SimulationMultiplexor_h
#define SimulationMultiplexor_h
#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <CpuMultiplexor.h>
#include <HardwareContext.h>

//
//	Like it says.
//
extern double CurrentSimulatedTime;
extern const double NullTime;

class TimeSchedulerPQ;

class SimulationMultiplexor {
protected:

    TimeSchedulerPQ *myPendingEvents;

    virtual int advanceTime();
    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

public:
    SimulationMultiplexor(int debug = 0);
    ~SimulationMultiplexor();

    virtual void addAt(Thread *, double);
    virtual void addWithDelay(Thread *, double);
    virtual void hold( double time );
    virtual void await( double time );
};

extern SimulationMultiplexor *ThisSimulationMultiplexor;

static inline double simulatedClock() {
    return( CurrentSimulatedTime );
}

static inline void await(double till)
{
    if ( till > CurrentSimulatedTime ) {
	ThisSimulationMultiplexor -> await(till);
    }
}

static inline void hold(double holdFor)
{
    ThisSimulationMultiplexor -> await( CurrentSimulatedTime + holdFor );
}

#endif /* SimulationMultiplexor_h */
