// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef SingleSimMux_h
#define SingleSimMux_h
#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <SimulationMultiplexor.h>
#include <SingleCpuMux.h>
#include <HardwareContext.h>

class SpinBarrier;
class TimeSchedulerPQ;

class SingleSimMux : public SimulationMultiplexor, public SingleCpuMux {
protected:

    virtual int advanceTime();
    virtual void allocateLocalEventStructures(int,int);
    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

    virtual Thread *remove();

public:
    SingleSimMux( int debug = 0 );

    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void add(Thread *);
};

#endif /* SingleSimMux_h */
