#include <stream.h>

#include "MultiFifoMux.h"
#include "ControlTask.h"
#include "Barrier.h"

main(int argc, char** argv)
{
    int from = (argc > 1) ? atoi(argv[1]) : 50;
    int to = (argc > 2) ? atoi(argv[2]) : (from + 100);
    int by = (argc > 3) ? atoi(argv[3]) : 50;
    int cpus = (argc > 4) ? atoi(argv[4]) : 1;
    bool debug = (argc > 5) ? atoi(argv[4]) : FALSE;

    MultiFifoMux Cpu(debug);

    cout << "From = " << from << " and to = " << to << "\n";
    cout << "with " << cpus << " cpus\n";

    Cpu.add( new ControlTask(from,to,by) );
    Cpu.fireItUp( cpus, to * 5000 * sizeof(long) + 1000000);

    cout << "Done!\n";
    extern Barrier TheBarrier;
    cout << "There are " << TheBarrier.count() << " tasks at the barrier \n";
}
