#include <stream.h>

//#include "SingleCpuMux.h"
//#include "MultiCpuMux.h"
#include "MultiFifoMux.h"
#include "ControlTask.h"
#include "Barrier.h"

int TotalShouldBe = 0;
extern int TheDataValue;

main(int argc, char** argv)
{
//    SingleCpuMux Cpu(0);

    int from = (argc > 1) ? atoi(argv[1]) : 50;
    int to = (argc > 2) ? atoi(argv[2]) : (from + 100);
    int by = (argc > 3) ? atoi(argv[3]) : 50;
    int cpus = (argc > 4) ? atoi(argv[4]) : 2;
    bool debug = (argc > 5) ? atoi(argv[4]) : 0;

    MultiFifoMux Cpu(debug);

    cout << "From = " << from << " and to = " << to << "\n";
    cout << "with " << cpus << " cpus\n";

    Cpu.add( new ControlTask(from,to,by) );

    Cpu.fireItUp( cpus, to * 5000 + 1000000);

    cout << "Done!\n";
    cout << "TotalShouldBe = " << TotalShouldBe << "\n";
    cout << "TheDataValue  = " << TheDataValue << "\n";
}
