#include <stream.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"

#include "Async.h"
#include "IoThread.h"

#define INFINITY		( (struct timeval *) NULL )
static struct timeval no_wait = { 0, 0 } ;
#define POLL			( &no_wait )

static int IOThread::nIOThreads = 0 ;

/*
 * The constructor ensures that there is exactly 1 I/O thread
 * It also gives the thread a name
 */
IOThread::IOThread( SingleCpuMux *Cpu )
{
	ASSERT( nIOThreads == 0  ) ;
	nIOThreads++ ;
	name( "I/O thread" ) ;
	cpu = Cpu ;
}


/*
 * main() loops forever checking if I/O is available on a file descriptor
 * If no descriptors have I/O available, and the run queue is empty
 * the I/O thread terminates
 */
void IOThread::main()
{
	/*
	 * Initial check for I/O (just in case we are the 1st thread
	 * to be scheduled).
	 *
	 * Check for I/O on any file descriptor
	 * If we are the only task running set the
	 * wait time to INFINITY
	 */
	Boolean programIsRunning = YES ;
#ifdef USE_SIGIO
	int mask = sigblock( sigmask( SIGIO ) ) ;
#endif
	if ( cpu->myCurrentEvents->isEmpty() )
		ioCheck( INFINITY ) ;
	else
		ioCheck( POLL ) ;
#ifdef USE_SIGIO
	(void) sigsetmask( mask ) ;
#endif

	while ( programIsRunning )
	{
		/*
		 * We are assuming here that we will be placed
		 * at the end of the run queue
		 */
		ThisCpu->raise( &ioException ) ;

#ifdef USE_SIGIO
		mask = sigblock( sigmask( SIGIO ) ) ;
#endif
		if ( AsyncIO::fdWidth[ 0 ] > 0 )
			if ( cpu->myCurrentEvents->isEmpty() )
				ioCheck( INFINITY ) ;
			else
				ioCheck( POLL ) ;
		else
			if ( cpu->myCurrentEvents->isEmpty() )
				programIsRunning = NO ;
#ifdef USE_SIGIO
		(void) sigsetmask( mask ) ;
#endif
	}
}

