#include <stream.h>
#include <sys/types.h>
/*
 * sys/socket.h provides prototypes for connect & accept and
 * also declares them as extern "C"
 */
#include <sys/socket.h>
#include <std.h>

/*
 * The following system calls are NOT is std.h (^&*(#$*(@)
 */
extern "C"
{
	int accept( int fd, struct sockaddr *name, int *namelen ) ;
	int connect( int fd, struct sockaddr *name, int namelen ) ;
}

#include "MultiAsync.h"

extern MultiAsyncIO *multiAsyncIO_array ;

int read( int fd, void *buf, unsigned nbytes )
{
	MultiAsyncIO::ioInit() ;
	return( multiAsyncIO_array[ fd ].read( fd, buf, nbytes ) ) ;
}


int write( int fd, const void *buf, unsigned nbytes )
{
	MultiAsyncIO::ioInit() ;
	return( multiAsyncIO_array[ fd ].write( fd, buf, nbytes ) ) ;
}


/*
 * The only reason for masking close is to have the destructor
 * for the particular fd called
int close( int fd )
{
	MultiAsyncIO::ioInit() ;
	multiAsyncIO_array[ fd ].fin() ;
	return( syscall( SYS_close, fd ) ) ;
}
 */


int connect( int fd, struct sockaddr *name, int namelen )
{
	MultiAsyncIO::ioInit() ;
	return( multiAsyncIO_array[ fd ].connect( fd, name, namelen ) ) ;
}


int accept( int fd, struct sockaddr *name, int *namelen )
{
	MultiAsyncIO::ioInit() ;
	return( multiAsyncIO_array[ fd ].accept( fd, name, namelen ) ) ;
}

