
#include "SpinLock.h"
#include "CpuMultiplexor.h"
#include "MultiCpuMuxExceptions.h"
#include "Async.h"

class MultiAsyncIO : public AsyncIO
{
	static SpinLock initLock ;

	ExceptionRelocate relocateException ;
	int owner ;

	void switchTo() ;
	void reschedule() ;

	static int signalHandlerInstalled[ MaxCpuMultiplexors ] ;
	
public:
	MultiAsyncIO() ;

	static void ioInit() ;

	void set_owner() ;

	int read( int fd, void *buf, unsigned nbytes ) ;
	int write( int fd, const void *buf, unsigned nbytes ) ;
	int accept( int fd, struct sockaddr *, int * ) ;
	int connect( int fd, struct sockaddr *, int ) ;
} ;


static inline void MultiAsyncIO::set_owner()
{
	owner = ThisCpu->cpuId() ;
}


inline MultiAsyncIO::MultiAsyncIO()
{
}


extern MultiAsyncIO *multiAsyncIO_array ;

