
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>

#include </usr/include/sys/syscall.h>

#include "Config-serial.h"
#include "ReserveByException.h"
#include "FifoScheduler.h"

enum IoType { READ, WRITE } ;
enum Boolean { NO, YES } ;

enum FDState { UNUSED, READY, ASYNC, NO_ASYNC } ;

class AsyncIO : public ReserveByException
{
	friend class IOThread ;
	friend void ioCheck( struct timeval * ) ;
	friend int fdReschedule( fd_set *, fd_set *, int ) ;

protected:
	static Boolean initialized ;

	static int n_fds ;
	static fd_set readMask[ MaxCpuMultiplexors ] ;
	static fd_set writeMask[ MaxCpuMultiplexors ] ;
	static int fdWidth[ MaxCpuMultiplexors ] ;	/* used to select(2) */

	FifoScheduler pileOfThreads ;
	virtual void reschedule() ;

private:
	/*
	 * We have only one pile of threads, i.e. we don't discriminate
	 * between threads waiting for input and threads waiting for output
	 */
	int fd ;
	int oldFdState ;
	int oldSignalMask ;
	FDState fdState ;

	Boolean streamWrite( int, unsigned &, int &, int & ) ;
	Boolean ioWait( IoType t ) ;

	void init( int fd ) ;
	void set_async() ;

	virtual int reserveByException( Thread *byWho ) ;

public:
	AsyncIO() ;

	static void ioInit() ;
	static void ioFin( int, void * ) ;
	
	void fin() ;

	int read( int fd, void *buf, unsigned nbytes ) ;
	int write( int fd, const void *buf, unsigned nbytes ) ;
	int accept( int fd, struct sockaddr *, int * ) ;
	int connect( int fd, struct sockaddr *, int ) ;
	int send( int fd, char *msg, int len, int flags ) ;
	int sendto( int fd, char *msg, int len, int flags,
					struct sockaddr *to, int tolen ) ;
	int sendmsg( int fd, struct msghdr *msg, int flags ) ;
	int recv( int fd, char *buf, int len, int flags ) ;
	int recvfrom( int fd, char *buf, int len, int flags,
					struct sockaddr *from, int *fromlen ) ;
	int recvmsg( int fd, struct msghdr *msg, int flags ) ;
} ;


static inline AsyncIO::AsyncIO()
{
	fdState = UNUSED ;
}


static inline void AsyncIO::init( int the_fd )
{
	if ( fdState == UNUSED )
	{
		fd = the_fd ;
		fdState = READY ;
	}
	set_async() ;
}


#define ASSERT( x )             assert( x )
#define FD_SET_NULL             ( (fd_set *)0 )

extern AsyncIO *asyncIO_array ;

