
#include <stream.h>

#include <sys/types.h>
#include <sys/socket.h>

#include "TestTask.h"

extern "C"
{
	int in_bind( short, int ) ;
	int in_connect( char *, short, int ) ;
}

TestTask::TestTask( char *taskName, TaskType t ) : ("foo", 10000, HARDWARE_CONTEXT_CHECK_MPROTECT)
{
	name( taskName ) ;
	type = t ;
	cout << "Task " << name() << " being created\n" ;
}

void TestTask::main()
{
	cout << "Task " << name() << " running\n" ;

    if ( type == RECEIVER )
    {
	int sd = in_bind( 12002, SOCK_STREAM ) ;

	if ( sd == -1 )
	{
		cerr << "in_bind failed. errno = " << errno << "\n" ;
		exit( 1 ) ;
	}
	listen( sd, 5 ) ;

	int new_sd = accept( sd, 0, 0 ) ;
	if ( new_sd == -1 )
	{
		cerr << "accept failed. errno = " << errno << "\n" ;
		exit( 1 ) ;
	}

	for ( ;; )
	{
		int cc = read( new_sd, buf, BUFFER_SIZE ) ;
		if ( cc == -1 )
		{
			cerr << "read failed. errno = " << errno << "\n" ;
			exit( 1 ) ;
		}
		if ( cc == 0 )
			break ;
		write( 2, buf, cc ) ;
	}
	/*
	close( new_sd ) ;
	close( sd ) ;
	*/
    }
    else
    {
	/*
	 * The first arg is really a string, determining the host name.
	 * If NULL, it implies local host
	 */
	int sd = in_connect( 0, 12002, SOCK_STREAM ) ;
	if ( sd == -1 )
	{
		cerr << "in_connect failed. errno = " << errno << "\n" ;
		exit( 1 ) ;
	}
	int fd = open( "/etc/passwd", 0 ) ;
	for ( ;; )
	{
		int cc = read( fd, buf, BUFFER_SIZE ) ;
		if ( cc == -1 )
		{
			cerr << "read failed. errno = " << errno << "\n" ;
			exit( 1 ) ;
		}
		if ( cc == 0 )
			break ;
		write( sd, buf, cc ) ;
	}
	/*
	close( fd ) ;
	close( sd ) ;
	*/
    }
	cout << "\nTask " << name() << " done\n" ;
}

