#ifndef CpuMultiplexor_h
#define CpuMultiplexor_h
#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <HardwareContext.h>
#include <CpuMuxExceptions.h>

//
//	Define the abstractions for per UNIX process resources.
//

class Thread;
class SEvPQ;
class SEv;
class SpinLock;
class ReserveByException;
class AwesimeHeap;
class SpinLock;
class SpinFetchAndOp;
class CpuMultiplexor;

//
//	Filled in by the single original UNIX process. This value may
//	change during execution
//

extern int CpuMultiplexors;
extern SpinLock CpuCerrLock;
extern CpuMultiplexor *ThisCpu;

class CpuMultiplexor {
protected:

    friend class SimulationMultiplexor;
    friend class SingleSimMux;
    friend class MultiSimMux;
    friend class MonitorSimMux;

    Thread *currentThread;
    HardwareContext systemContext;

    int iYam;	// I yam what I yam
    int pid;	// ...except to UNIX

    char nameSpace[128];
    char *pNameTemplate;
    char *pName;

    int *terminated;
    int enabled;

    //
    //	Exception handlers.
    //

    friend class ExceptionReserve;
    friend class ExceptionTerminate;
    friend class ExceptionReschedule;
    friend class ExceptionIveSuspended;
    friend class ExceptionRelocate;
    friend class ExceptionEnrollDismissCpu;

    ExceptionClass *raisedBy;
    ExceptionReserve reserveException;
    ExceptionTerminate terminateException;
    ExceptionReschedule rescheduleException;
    ExceptionIveSuspended iveSuspendedException;

    //
    //	Public interfaces for exceptions -- this are non virtual and
    //  are inline defined in CpuMultiplexorP.h
    //
public:

    void raise(ExceptionClass *);
    void reserveByException( ReserveByException * );
    void threadTerminateException( Thread* );
    void flick();

public:
    CpuMultiplexor(int debug = 0);
    virtual ~CpuMultiplexor();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void terminateAll();
    virtual void add(Thread *);

    Thread * CurrentThread();

    void debug(int newdebug);
    int debug();
    char *name();

    int cpuId();
};

static inline int
CpuMultiplexor::cpuId()
{
    return( iYam );
}

static inline char *
CpuMultiplexor::name()
{
    return(pName);
}

static inline Thread *
CpuMultiplexor::CurrentThread()
{
    return( currentThread );
}

static inline Thread *
CurrentThread()
{
    return( ThisCpu -> CurrentThread() );
}

#endif /* CpuMultiplexor_h */
