#ifndef CpuMultiplexorP_h
#define CpuMultiplexorP_h

#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <CpuMultiplexor.h>
#include <HardwareContext.h>
#include <HardwareContextP.h>
#include <SpinLock.h>
#include <Thread.h>

extern SpinLock CpuCerrLock;

//
//	Expansions for exception handling
//

static inline void
CpuMultiplexor::raise(ExceptionClass *by)
{
    assert( by != 0 );
    raisedBy = by;
    currentThread -> pContext.switchContext( &systemContext );
}

static inline void
CpuMultiplexor::reserveByException( ReserveByException *sem )
{
    reserveException.reserve(sem);
    raise( &reserveException );
}

static inline void
CpuMultiplexor::threadTerminateException( Thread *killMe )
{
    terminateException.terminate( killMe );
    raise( &terminateException );
}

//
//	These are things the user needs to define
//

extern ThreadContainer *AllocateHardwareCurrentEventsStructure();

#endif /* CpuMultiplexorP_h */
