#include <stream.h>
#include "LP.h"
#include "LPmsgptr.XPQueue.h"
#include <assert.h>

static ClassId ThisClassId = "LP";

ClassId
LP::classId()
{
    return( ThisClassId );
}

bool
LP::isA(ClassId id)
{
    return( id == ThisClassId );
}


LP::LP(char *n)
{
    pName = n;

    numberOfInputs = 0;
    in = 0;

    numberOfOutputs = 0;
    out = 0;

    divertedMessages = 0;
}


LP::~LP()
{
    if ( out ) {
	delete out;
    }
    if ( in ) {
	delete in;
    }
}

int
LP::allocInput(LP *lp)
{
    int slot = numberOfInputs;
    numberOfInputs++;
    
    if ( in == 0 ) {
	in = (LP **) malloc( sizeof(LP* ) );
    } else {
	in = (LP **) realloc(in,  sizeof(LP*) * numberOfInputs );
    }

    in[ slot ] = lp;
    return( slot );
}

int
LP::allocOutput(LP *lp, int returnChannel)
{
    int slot = numberOfOutputs;
    numberOfOutputs++;
    
    if ( out == 0 ) {
	out = (LPOutputToInputMapping *)
	    malloc( sizeof(LPOutputToInputMapping ) );
    } else {
	out = (LPOutputToInputMapping *)
	    realloc(out, sizeof(LPOutputToInputMapping) * numberOfOutputs );
    }

    out[ slot ].lp = lp;
    out[ slot ].returnChannel = returnChannel;

    return( slot );
}

void
LP::deliver( LP *,  LPmsg* )
{
    assert( 0 );
}

void
LP::deliverSelf(LPmsg* what )
{
    assert( 0 );
}

void
LP::deliverLast(LP *, LPmsg* )
{
    assert( 0 );
}

void
LP::action( LPmsg* what )
{
    assert( 0 );
}

void LP::divert(LPmsg *what)
{
    if ( ! divertedMessages ) {
	divertedMessages = new LPmsgptrXPQueue;
	assert(divertedMessages);
    }
    divertedMessages -> enq(what);
}

void LP::divert(LPmsg *what, TimeUnit when)
{
    what -> simulatedTime( when );
    if ( ! divertedMessages ) {
	divertedMessages = new LPmsgptrXPQueue;
	assert(divertedMessages);
    }
    divertedMessages -> enq(what);
}

void LP::undivert()
{
    if ( divertedMessages ) {
	while (! divertedMessages -> empty() ) {
	    LPmsg *event = divertedMessages -> deq();
	    action( event );
	    delete event;
	}
    }
}

void LP::busyUntil(TimeUnit time)
{
    assert( 0 );
}

void LP::busyFor(TimeUnit time)
{
    assert( 0 );
}

