#ifndef _LP_h_
#define _LP_h_

#include "LPmsg.h"
#include "bool.h"

class LP;
class LPmsgptrQueue;

#define LP_BUSY_TYPE 0xfffff

typedef struct {
    LP *lp;
    int returnChannel;
} LPOutputToInputMapping;

class LP {

protected:
    char *pName;
    char isSchedule();

    int numberOfOutputs;
    LPOutputToInputMapping *out;
    int numberOfInputs;
    LP **in;

    LPmsgptrQueue *divertedMessages;
    bool isBusy;

public:
    LP(char *name = "");
    virtual ~LP();

    void name(char *);
    char *name();

    static ClassId classId();
    virtual bool isA(ClassId);

    //
    // allocInput returns the input slot #.
    // who is the LP being wired into that slot number.
    // This is only called by allocOutput.
    //
    virtual int allocInput(LP *who);

    //
    // allocOutput creates an output, binding the LP and their input
    // channel to that slot.
    //
    virtual int allocOutput(LP *who, int theirChannel);

    //
    // deliver a message to another LP
    //
    virtual void deliver( LP *who, LPmsg* what );
    virtual void deliverSelf(LPmsg* what );
    virtual void deliverLast( LP *who, LPmsg* what );

    virtual void divert(LPmsg *what);
    virtual void divert(LPmsg *what, TimeUnit when);
    virtual void undivert();

    bool busy();
    void makeBusy();
    void makeUnBusy();
    virtual void busyUntil(TimeUnit time);
    virtual void busyFor(TimeUnit time);
    bool checkBusy(LPmsg *what);

    //
    // act on a message
    //
    virtual void action( LPmsg* what );
}; 

static inline char*
LP::name()
{
    return ( pName );
}

static inline void
LP::name(char *n)
{
    pName = n;
}

static inline
void LP::makeBusy()
{
    isBusy = TRUE;
}

static inline
bool LP::busy()
{
    return( isBusy );
}

static inline
void LP::makeUnBusy()
{
    isBusy = FALSE;
}

static inline
bool LP::checkBusy(LPmsg *what)
{
    if ( isBusy ) {
	if ( what -> type() == LPmsgTypeUnBusy ) {
	    isBusy = FALSE;
	    undivert();
	    return ( TRUE );
	} else {
	    divert( what );
	    return ( TRUE );
	}
    } else {
	return (FALSE); // not busy
    }
}

#endif
