#include "SpinLock.h"
#include "LPmsg.h"
#include "LPmsg.SplayPQ.h"

//
// Provide constructors/destructors for LPmsg
//

static ClassId ThisClassId = "LPmsg";

ClassId
LPmsg::classId()
{
    return( ThisClassId );
}

bool
LPmsg::isA(ClassId id)
{
    return( id == ThisClassId );
}



#if 0

static SpinLock LPmsgFreeLock;
static int LPmsgAllocateChunk = 4;
static LPmsg *LPmsgfreeList = 0;

#define LPmsg_LINK(x) ( (x)[0].lp )

void *
LPmsg::operator new(long size)
LPmsg*
makeMoreLPmsg()
{
    LPmsgFreeLock.reserve();
    
    if ( LPmsgfreeList == 0 ) {
	LPmsg *p
	    = (LPmsg *) new char[ sizeof(LPmsg) * LPmsgAllocateChunk ];
	for (int i = 0; i < LPmsgAllocateChunk; i++ ) {
	    LPmsg_LINK(p[i]) = &(p[i+1]);
	}
	LPmsg_LINK(p[ LPmsgAllocateChunk - 1]) = 0;
	LPmsgfreeList = &(p[ 0 ]);

	LPmsgAllocateChunk *= 2;
    }
    LPmsg *t = LPmsgfreeList;
    LPmsgfreeList = LPmsg_LINK( *LPmsgfreeList );
    LPmsg_LINK( *t ) = 0;
    LPmsgFreeLock.release();
    return(t);
}

void
LPmsg::operator delete(void *p)
void
deleteLPmsg(LPmsg *p)
{
    //
    // why would anyone ever pass NULL to the delete?
    //
    assert( p != 0 );
    LPmsgFreeLock.reserve();
    LPmsg *pp = (LPmsg *)p;
    LPmsg_LINK( *pp ) = LPmsgfreeList;
    LPmsgfreeList = pp;
    LPmsgFreeLock.release();
}
#endif

//
// Provide constructors/destructors for LPmsgSplayNode
//

#if 0

static SpinLock LPmsgSplayNodeFreeLock;
static const int LPmsgSplayNodeAllocateChunk = 1000;
static LPmsgSplayNode *LPmsgSplayNodefreeList = 0;

#define LPmsgSplayNode_LINK(x) ( (LPmsgSplayNode *) (x).lt )

void *
LPmsgSplayNode::operator new(long size)
{
//    assert( size == sizeof(LPmsgSplayNode) );

    LPmsgSplayNodeFreeLock.reserve();
    
    if ( LPmsgSplayNodefreeList == 0 ) {
	LPmsgSplayNode *p
	    = (LPmsgSplayNode *) new char[ sizeof(LPmsgSplayNode) * LPmsgSplayNodeAllocateChunk ];
	for (int i = 0; i < LPmsgSplayNodeAllocateChunk; i++ ) {
	    LPmsgSplayNode_LINK(p[i]) = &(p[i+1]);
	}
	LPmsgSplayNode_LINK(p[ LPmsgSplayNodeAllocateChunk - 1]) = 0;
	LPmsgSplayNodefreeList = &(p[ 0 ]);
    }
    LPmsgSplayNode *t = LPmsgSplayNodefreeList;
    LPmsgSplayNodefreeList = LPmsgSplayNode_LINK( *LPmsgSplayNodefreeList );
    LPmsgSplayNode_LINK( *t ) = 0;
    LPmsgSplayNodeFreeLock.release();
    return(t);
}

void
LPmsgSplayNode::operator delete(void *p)
{
    //
    // why would anyone ever pass NULL to the delete?
    //
    assert( p != 0 );
    if ( p != 0 ) {
	LPmsgSplayNodeFreeLock.reserve();
	LPmsgSplayNode *pp = (LPmsgSplayNode *)p;
	LPmsgSplayNode_LINK( *pp ) = LPmsgSplayNodefreeList;
	LPmsgSplayNodefreeList = pp;
	LPmsgSplayNodeFreeLock.release();
    }
}

#endif
