#ifndef _LPmsgdefs_h_
#define _LPmsgdefs_h_ 1

#include "LPmsg.h"

// equality operator
#ifndef LPmsgEQ
#define LPmsgEQ(a, b)  ((a) == (b))
#endif

// less-than-or-equal
#ifndef LPmsgLE
#define LPmsgLE(a, b)  ((a) <= (b))
#endif

// comparison : less-than -> < 0; equal -> 0; greater-than -> > 0
#ifndef LPmsgCMP
#define LPmsgCMP(a, b) (a.compare(b))
#endif

// hash function
#ifndef LPmsgHASH
extern unsigned int hash(LPmsg&);
#define LPmsgHASH(x)  hash(x)
#endif

// initial capacity for structures requiring one

#ifndef DEFAULT_INITIAL_CAPACITY
#define DEFAULT_INITIAL_CAPACITY 100
#endif

#endif
