// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _LPmsgptrSplayPQ_h
#pragma once
#define _LPmsgptrSplayPQ_h 1

#include "LPmsgptr.PQ.h"

#ifndef _LPmsgptrSplayNode
#define _LPmsgptrSplayNode 1

struct LPmsgptrSplayNode
{
  LPmsgptrSplayNode*   lt;
  LPmsgptrSplayNode*   rt;
  LPmsgptrSplayNode*   par;
  LPmsgptr             item;
                  LPmsgptrSplayNode(LPmsgptr  h, LPmsgptrSplayNode* l=0, LPmsgptrSplayNode* r=0);
                  ~LPmsgptrSplayNode();
};


inline LPmsgptrSplayNode::LPmsgptrSplayNode(LPmsgptr  h, LPmsgptrSplayNode* l=0, LPmsgptrSplayNode* r=0)
{
  item = h;
  lt = l;
  rt = r;
  par = 0;
}

inline LPmsgptrSplayNode::~LPmsgptrSplayNode() {}

typedef LPmsgptrSplayNode* LPmsgptrSplayNodePtr;

#endif

class LPmsgptrSplayPQ : public LPmsgptrPQ
{
protected:
  LPmsgptrSplayNode*   root;

  LPmsgptrSplayNode*   leftmost();
  LPmsgptrSplayNode*   rightmost();
  LPmsgptrSplayNode*   pred(LPmsgptrSplayNode* t);
  LPmsgptrSplayNode*   succ(LPmsgptrSplayNode* t);
  void            _kill(LPmsgptrSplayNode* t);
  LPmsgptrSplayNode*   _copy(LPmsgptrSplayNode* t);

public:
                  LPmsgptrSplayPQ();
                  LPmsgptrSplayPQ(LPmsgptrSplayPQ& a);
                  ~LPmsgptrSplayPQ();

  Pix           enq(LPmsgptr  item);
  LPmsgptr           deq(); 

  LPmsgptr&          front();
  void          del_front();

  int           contains(LPmsgptr  item);

  void          clear(); 

  Pix           first(); 
  Pix           last(); 
  void          next(Pix& i);
  void          prev(Pix& i);
  LPmsgptr&          operator () (Pix i);
  void          del(Pix i);
  Pix           seek(LPmsgptr  item);

  int           OK();                    // rep invariant
};

inline LPmsgptrSplayPQ::~LPmsgptrSplayPQ()
{
  _kill(root);
}

inline LPmsgptrSplayPQ::LPmsgptrSplayPQ()
{
  root = 0;
  count = 0;
}

inline LPmsgptrSplayPQ::LPmsgptrSplayPQ(LPmsgptrSplayPQ& b)
{
  count = b.count;
  root = _copy(b.root);
}

inline Pix LPmsgptrSplayPQ::first()
{
  return Pix(leftmost());
}

inline Pix LPmsgptrSplayPQ::last()
{
  return Pix(rightmost());
}

inline void LPmsgptrSplayPQ::next(Pix& i)
{
  if (i != 0) i = Pix(succ((LPmsgptrSplayNode*)i));
}

inline void LPmsgptrSplayPQ::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((LPmsgptrSplayNode*)i));
}

inline LPmsgptr& LPmsgptrSplayPQ::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((LPmsgptrSplayNode*)i)->item;
}

inline void LPmsgptrSplayPQ::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int LPmsgptrSplayPQ::contains(LPmsgptr  key)
{
  return seek(key) != 0;
}


#endif
